package cn.myapps.runtime.dynaform.form.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;
import net.sf.json.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import javax.servlet.http.Cookie;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * 评论控件测试类
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class CommentControllerTest extends AbstractControllerTests {

    private String applicationId = "sOZu9kthmxyP8qQfq0e";

    private String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

    private String commentId;

    /**
     * 模拟用户登陆，将用户对象放入cookie中。
     * @throws Exception
     */
    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        String userid = "zPsp2hk7CEwtqeMCwtj";
        UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
        String token = Security.getToken(userid);
        // 存放到cookie
        cookie = new Cookie(Security.ACCESS_TOKEN, token);
        cookie.setPath("/");
    }

    /**
     * 测试 /api/runtime/{applicationId}/documents/{docId}/comments
     * 获取新建评论（回复）
     */
    @Test
    public void testCreateComment() throws Exception {
        String content = "{\"comment\":\"哈哈哈\",\"parentId\":\"\"}";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/runtime/" + applicationId + "/documents/" + docId + "/comments");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);

        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        String result = resultActions.andReturn().getResponse().getContentAsString();

        JSONObject jsonObj = JSONObject.fromObject(result);
        JSONObject json = jsonObj.getJSONObject("data");
        commentId = json.getString("id");

        //获取评论列表
        testGetComments();
        //获取回复列表
        testGetAnswers();
        //点赞
        testLikeComment();
        //觉得不行
        testUnlikeComment();
    }

    /**
     * 测试 GET /api/runtime/{applicationId}/documents/{docId}/comments
     * 获取评论列表
     */
    private void testGetComments() throws Exception {
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/runtime/" + applicationId + "/documents/" + docId + "/comments");
        requestBuilder.cookie(cookie);

        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 测试 GET /api/runtime/{applicationId}/documents/comments/{commentId}/answers
     * 获取回复列表
     */
    private void testGetAnswers() throws Exception {
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/runtime/" + applicationId + "/documents/comments/" + commentId + "/answers");
        requestBuilder.cookie(cookie);

        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 测试 /api/runtime/{applicationId}/documents/comments/{commentId}/like
     * 点赞
     */
    private void testLikeComment() throws Exception {
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/runtime/" + applicationId + "/documents/comments/" + commentId + "/like");
        requestBuilder.cookie(cookie);

        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 测试 /api/runtime/{applicationId}/documents/comments/{commentId}/unlike
     * 觉得不行
     */
    private void testUnlikeComment() throws Exception {
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/runtime/" + applicationId + "/documents/comments/" + commentId + "/unlike");
        requestBuilder.cookie(cookie);

        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}

