package cn.myapps.runtime.dynaform.document.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.sequence.Sequence;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class DocumentControllerTest extends AbstractControllerTests {

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/documents/{id} 接口<br/>
	 * 获取一个文档对象
	 */
	@Test
	public void testGetDocument() {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		try {
			RequestBuilder request = buildGetRequest("/api/runtime/" + applicationId + "/documents/" + id);
			((MockHttpServletRequestBuilder) request).cookie(cookie);
			mockMvc.perform(request).andExpect(status().isOk())
					.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE))
					.andExpect(jsonPath("$.errcode").value(0)).andExpect(jsonPath("$.errmsg").value("ok"))
					.andExpect(jsonPath("$.data.id").isNotEmpty());
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	/**
	 * 测试 POST /api/runtime/{applicationId}/documents 接口<br/>
	 * 创建文档对象
	 * 测试 PUT /api/runtime/{applicationId}/documents{id} 接口<br/>
	 * 更新文档对象
	 * 测试 PATCH /api/runtime/{applicationId}/documents/{id} 接口<br/>
	 * 局部更新文档对象
	 * 测试 DELETE /api/runtime/{applicationId}/documents/{id} 接口<br/>
	 * 删除文档对象
	 */
	@Test
	public void testCreateDocument() {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = null;
		try {
			id = Sequence.getSequence();
			System.out.println(id);
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		JSONObject contentMap = new JSONObject();
		contentMap.put("id", id);
		contentMap.put("parentid", "");
		contentMap.put("formId", "__r3Uat20oAOwkP9f8fCl");
		contentMap.put("applicationid", applicationId);
		contentMap.put("stateid", "");
		contentMap.put("versions", 0);
		contentMap.put("sign", "");

		JSONObject itemsMap = new JSONObject();
		itemsMap.put("金额", "2");
		itemsMap.put("数量", "2");
		itemsMap.put("规格", "2");

		contentMap.put("items", itemsMap);
		String content = contentMap.toJSONString();
		try {
			MockHttpServletRequestBuilder request = buildPostRequest("/api/runtime/" + applicationId + "/documents" + "/withoutValid");
			request.cookie(cookie);
			request.content(content);

			ResultActions resultActions = mockMvc.perform(request);
			resultActions.andExpect(jsonPath("$.errcode").value(0));
//			resultActions.andExpect(jsonPath("$.errmsg").value("保存成功")).andExpect(jsonPath("$.data.id").value(id));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
//
//		JSONObject contentMap2 = new JSONObject();
//		contentMap2.put("id", id);
//		contentMap2.put("parentid", "");
//		contentMap2.put("formId", "Q11e7-66ae-5d010543-9cdb-af6bc8266ed2");
//		contentMap2.put("applicationid", applicationId);
//		contentMap2.put("stateid", "");
//		contentMap2.put("versions", 4);
//		contentMap2.put("sign", "");
//
//		JSONObject itemsMap2 = new JSONObject();
//		itemsMap.put("列表视图_文本一", "1");
//		itemsMap.put("列表视图_文本二", "1");
//
//		contentMap2.put("items", itemsMap2);
//
//		String content2 = contentMap2.toJSONString();

//		try {
//			MockHttpServletRequestBuilder request = buildPutRequest("/api/runtime/" + applicationId + "/documents/" + id + "/withoutValid");
//			request.content(content2);
//			request.cookie(cookie);
//			ResultActions resultActions = mockMvc.perform(request);
//			resultActions.andExpect(jsonPath("$.errcode").value(0));
//			resultActions.andExpect(jsonPath("$.errmsg").value("保存成功")).andExpect(jsonPath("$.data.id").value(id));
//		} catch (Exception e) {
//			Assert.fail(e.getMessage());
//		}
//
//		JSONObject contentMap3 = new JSONObject();
//		contentMap.put("id", id);
//
//		JSONObject itemsMap3 = new JSONObject();
//		itemsMap.put("列表视图_文本一", "12345");
//		itemsMap.put("列表视图_文本二", "不23456");
//		contentMap3.put("items", itemsMap3);
//
//		try {
//			String content3 = contentMap.toJSONString();
//			MockHttpServletRequestBuilder request = buildPatchRequest("/api/runtime/" + applicationId + "/documents/" + id);
//			request.cookie(cookie);
//			request.content(content3);
//
//			ResultActions resultActions = mockMvc.perform(request);
//			resultActions.andExpect(jsonPath("$.errcode").value(0));
//			resultActions.andExpect(jsonPath("$.errmsg").value("保存成功"));
//		} catch (Exception e) {
//			Assert.fail(e.getMessage());
//		}
//
//		try {
//			MockHttpServletRequestBuilder request = buildDeleteRequest(
//					"/api/runtime/" + applicationId + "/documents/" + id);
//			request.cookie(cookie);
//			ResultActions resultActions = mockMvc.perform(request);
//			resultActions.andExpect(status().isOk());
//			resultActions.andExpect(jsonPath("$.errcode").value(0));
//			resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//		} catch (Exception e) {
//			Assert.fail(e.getMessage());
//		}


	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/documents 接口<br/>
	 * 批量获取文档集合
	 */
	@Test
	public void testGetDocuments() {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("_page", "1");
		params.add("_page_lines", "10");
		params.add("_sortCols", "lastmodified");
		params.add("order", "desc");
		String content = "{\"formid\":\"__r3Uat20oAOwkP9f8fCl\"}";
		try {
			MockHttpServletRequestBuilder request = buildGetRequest("/api/runtime/" + applicationId + "/documents");
			request.cookie(cookie);
			request.params(params).content(content);
			mockMvc.perform(request).andExpect(jsonPath("$.errcode").value(0))
					.andExpect(jsonPath("$.errmsg").value("ok"));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	/**
	 * 测试 DELETE /api/runtime/{applicationId}/documents 接口<br/>
	 * 批量删除文档
	 */
	@Test
	public void testBatchDeleteDocument() {

		JSONArray json = new JSONArray();
		json.add("__Tq6JlXlWWwVyQ2CTnaA--__0YLxcnXBE1G5atft4oU");
		json.add("__Tq6JlXlWWwVyQ2CTnaA--__0YLxcnXBE1G5atft4oU");
		//json.add("Q11e7-6d50-bdbd24ae-966a-876161d2b77c");
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String content = json.toJSONString();

		try {
			MockHttpServletRequestBuilder request = buildDeleteRequest("/api/runtime/" + applicationId + "/documents");
			request.cookie(cookie);
			request.content(content);
			mockMvc.perform(request).andExpect(status().isOk()).andExpect(jsonPath("$.errcode").value(0))
					.andExpect(jsonPath("$.errmsg").value("ok"));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void doGetTreeDocuments() {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id ="__8ggTzyy9drzN7L4TPqr";
		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("parentId", "");
		params.add("name", "");
		String content = "{}";
		try {
			MockHttpServletRequestBuilder request = buildPostRequest("/api/runtime/" + applicationId + "/treeviews/"+id+"/documents");
			request.cookie(cookie);
			request.params(params).content(content);
			mockMvc.perform(request).andExpect(jsonPath("$.errcode").value(0))
					.andExpect(jsonPath("$.errmsg").value("ok"));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}
}
