package cn.myapps.runtime.department.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * departmentSelectbox Restful 测试类
 * @author spy
 */

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class DepartmentSelectboxControllerTest extends AbstractControllerTests{

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/departments/selectbox/department?deptId={deptId} 接口<br/>
	 * 获取树形结构的部门集合<br/>
	 * 返回直属下级部门的集合，以树形结构的方式描述数据。
	 */
	@Test
	public void testGetDepartmentListTree() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String deptId = "";
		int level = -1;
		boolean belong = false;
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/"+applicationId+"/departments/selectbox/department?deptId="+deptId+"&level="+level+"&belong="+belong);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/departments/selectbox/user?deptId={deptId} 接口<br/>
	 * 获取部门或该部门下用户集合<br/>
	 * 当部门id为空时返回所有部门集合，否则返回该部门下所有用户集合数据。
	 */
	@Test
	public void testGetDepartmentAndUsers() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String deptId = "5QDZimSIUiHplt9D3uU";
		Integer pageSize = 1;
		Integer pageNum = 1;
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/"+applicationId+"/departments/selectbox/user?deptId="+deptId+"&pageSize="+pageSize+"&pageNum="+pageNum);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	@Test
	public void testsearchDeptTree() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/"+applicationId+"/departments/selectbox/search?keyword=a");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

}
