package cn.myapps.runtime.chart.service;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.chart.Chart;
import cn.myapps.common.util.SequenceGenerator;
import cn.myapps.run.RuntimeWithConsulApp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest(classes=RuntimeWithConsulApp.class)
public class TestChart {
	
	@Autowired
	private ChartServiceImpl service;
	@Test
	public void testBuildEChartOption() throws Exception {
		Chart chart = new Chart();
		chart.setId(SequenceGenerator.getUUID());
		chart.setName("test");
		chart.setScripttext("(function(){\r\n" + 
				"	var str = \"option = {title: {text: 'ECharts 入门示例'},tooltip: {},legend: {data:['销量']},xAxis: {data: [\"衬衫\",\"羊毛衫\",\"雪纺衫\",\"裤子\",\"高跟鞋\",\"袜子\"]},yAxis: {},series: [{name: '销量',type: 'bar',data: [5, 20, 36, 10, 10, 20]}]}\";\r\n" + 
				"	return str;\r\n" + 
				"	})();");
		
		
		System.out.println(chart.getScripttext());
		ParamsTable params = new ParamsTable();
		params.setSessionid("sessionid");
		
		WebUser user = new WebUser();

		Object result = service.buildEChartOption(chart, params, user, null);
		System.out.println(result);
		Assert.assertEquals("option={}", result);
	}
}
