package cn.myapps.runtime.activity.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;

/**
 * Activity Restful 测试类
 *
 * @author ahan
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class ActivityControllerTest extends AbstractControllerTests {

	/**
	 * 模拟用户登陆，将用户对象放入session中。
	 *
	 * @throws Exception
	 */
	WebUser webUser = null;

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 /api/runtime/{applicationId}/activities/{id}/runbeforeactionscript 接口<br/>
	 * 执行按钮的执行前脚本
	 *
	 * @throws Exception
	 */
	@Test
	public void testRunBeforeActionScript() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String formid = "__r3Uat20oAOwkP9f8fCl";

		// 缓存里需要有对应的文档
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				application);
		Document doc = (Document) dProcess.doView(docid);

//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);

		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("docid", docid);
		params.add("formid", formid);
		String str = "{\"docId\":\"\",\"viewId\":\"Gc5icb2c0g8ARf7Jath\",\"formId\":\"\",\"templateForm\":\"\",\"parentId\":\"\",\"document\":{},\"_selects\":[]}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + application + "/activities/" + id + "/runbeforeactionscript");
		requestBuilder.cookie(cookie);
		requestBuilder.params(params);
		requestBuilder.content(str);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 /api/runtime/{applicationId}/activities/{id}/runafteractionscript 接口<br/>
	 * 执行按钮的执行后脚本
	 *
	 * @throws Exception
	 */
	@Test
	public void testRunAfterActionScript() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String formid = "__r3Uat20oAOwkP9f8fCl";
		String content = "{'document':{}}";

		// 缓存里需要有对应的文档
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				application);
		Document doc = (Document) dProcess.doView(docid);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);

		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("docId", docid);
		params.add("formId", formid);

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + application + "/activities/" + id + "/runafteractionscript");
		requestBuilder.content(content);
		requestBuilder.params(params);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 /api/runtime/{applicationId}/activities/{id}/runScript 接口<br/>
	 *
	 * @throws Exception
	 */
	@Test
	public void testRunScript() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String fieldName = "readonlyScript";

		// 缓存里需要有对应的文档
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				application);
		Document doc = (Document) dProcess.doView(docid);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + application + "/activities/" + id + "/runScript?docId="+docid+"&fieldName="+fieldName);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));

	}

	/**
	 * 测试 /api/runtime/{applicationId}/activities/{id}/execute 接口<br/>
	 * 执行自定义按钮的执行脚本
	 *
	 * @throws Exception
	 */
	@Test
	public void testExecute() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String formid = "__r3Uat20oAOwkP9f8fCl";
		String content = "{'document':{}}";
		// 缓存里需要有对应的文档
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				application);
		Document doc = (Document) dProcess.doView(docid);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);

		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("docid", docid);
		params.add("formid", formid);

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/activities/" + id + "/execute");
		requestBuilder.content(content);
		requestBuilder.params(params);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/archive 接口<br/>
	 * 归档操作
	 */
	@Test
	public void testArchive() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/documents/" + docid + "/activities/archive");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/saveStartWorkFlow 接口<br/>
	 * 保存并启动流程操作
	 */
	@Test
	public void testSaveStartWorkFlow() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				applicationId);
		Document doc = (Document) dProcess.doView(docid);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);

//		JSONObject contentMap = new JSONObject();
//
//		JSONObject itemsMap = new JSONObject();
//		itemsMap.put("单行文本", "xjd");
//
//		JSONObject document = new JSONObject();
//		document.put("items", itemsMap);
//
//		contentMap.put("document", document);
//
//		String content = contentMap.toString();

		String content = "{\"document\":{\"items\":{\"备注\":\"\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\"__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl\",\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"}}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/documents/activities/saveStartWorkFlow");
		requestBuilder.content(content);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/copy 接口<br/>
	 * 复制操作
	 */
	@Test
	public void testCopy() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String formId ="__r3Uat20oAOwkP9f8fCl";
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				applicationId);
		Document doc = (Document) dProcess.doView(docid);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);
//
//		JSONObject contentMap = new JSONObject();
//
//		JSONObject itemsMap = new JSONObject();
//		itemsMap.put("单行文本", "123");
//
//		JSONObject document = new JSONObject();
//		document.put("items", itemsMap);
//
//		contentMap.put("document", document);

//		String content = contentMap.toString();

		String content = "{\"document\":{\"items\":{},\"applicationId\":"+applicationId+",\"id\":"+id+",\"formId\":"+formId+",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"}}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/documents/" + docid + "/activities/copy");
		requestBuilder.content(content);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/forms/{formId}/activities/clear 接口<br/>
	 * 清楚所有数据操作
	 */
	@Test
	public void testClear() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formId = "__0YLxcnXBE1G5atft4oU";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildDeleteRequest(
				"/api/runtime/" + applicationId + "/forms/" + formId +  "/activities/clear");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/sign 接口<br/>
	 * 签章操作
	 */
	@Test
	public void testSign() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String formId = "__r3Uat20oAOwkP9f8fCl";
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				applicationId);
		Document doc = (Document) dProcess.doView(docId);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);

		String content = "{\"document\":{\"items\":{},\"applicationId\":"+applicationId+",\"id\":"+id+",\"formId\":"+formId+",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"}}";


//		// 缓存里需要有对应的文档


		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/documents/" + docId +  "/activities/sign");
		requestBuilder.content(content);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/download?actId={actId} 接口<br/>
	 * 文件下载操作
	 */
	@Test
	public void testDownload() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String actId = "__hGSekJLnneT6Vu9SYqs";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/documents/" +docId + "/activities/download?actId=" + actId);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/viewId/{viewId}/activities/exportExcel 接口<br/>
	 * excel导出操作
	 */
	@Test
	public void testExportExcel() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String viewId = "__8ggTzyy9drzN7L4TPqr";
		String actId = "__hGSekJLnneT6Vu9SYqs";
		String filename = "新建、删除、清除所有数据、批量提交、批量签章、导出Excel";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/views/" + viewId + "/activities/exportExcel?actId=" + actId + "&filename=" + filename);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/share 接口<br/>
	 * 通过邮件或手机短信分享操作
	 */
	@Test
	public void testShare() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		// 缓存里需要有对应的文档

		String content = "{\"transpond\":\"__6XgnshVrUL4nIjBfJQ7\",\"handleUrl\":\"/obpm/portal/good/form.html?appId=sOZu9kthmxyP8qQfq0e&docId=__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl&formId=__r3Uat20oAOwkP9f8fCl\",\"receiverid\":\"zPsp2hk7CEwtqeMCwtj\",\"email\":false,\"msm\":false}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/documents/" + docId + "/activities/share");
		requestBuilder.content(content);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/activities/exportPdf 接口<br/>
	 * pdf导出操作
	 */
	@Test
	public void testExportPdf() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String formId = "__r3Uat20oAOwkP9f8fCl";

		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				applicationId);
		Document doc = (Document) dProcess.doView(docId);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/forms/" + formId +"/documents/" + docId + "/activities/exportPdf");
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/print 接口<br/>
	 * 打印操作
	 */
	@Test
	public void testPrint() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formId = "KTUVIziKNkjs3j5K8TX";
		String docId = "1VIR0ugu12dYw5j5tCq";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/forms/" + formId + "/documents/" + docId + "/activities/print");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/views/{viewId}/activities/importExcel 接口<br/>
	 * 导入操作
	 */
	@Test
	public void testImportExcel() throws Exception {
		String path = PropertyUtil.getPath()+"/uploads/resource/";
		String sourcePath = path + "1.xls";
		String destPath = path + "2.xls";
		File source = new File(sourcePath);
		File dest = new File(destPath);
		if (!dest.exists())
			Files.copy(source.toPath(), dest.toPath());

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String viewId = "__fD7VIEbZQzPjcFTj9uB";

		JSONObject contentMap = new JSONObject();
		contentMap.put("actId", "__40emGJNf6tjS1EuJSve");
		contentMap.put("impmappingconfigid", "__6XGibM8vHvaKjA1XJeS");
		contentMap.put("path", "/uploads/resource/2.xls");

		String content = contentMap.toString();

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/views/" + viewId + "/activities/importExcel");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
	}

	/**
	 * 测试 /api/runtime/{applicationId}/forms/activities/batchApprove 接口<br/>
	 * 批量提交操作
	 */
	@Test
	public void testBatchApprove() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";

		JSONObject contentMap = new JSONObject();
		contentMap.put("limistStrList", "");
		List<String> docIds = new ArrayList<String>();
		docIds.add("__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl");
		//docIds.add("XTuIPs7RxseePzK6Qvs");
		contentMap.put("docIds", docIds);
		contentMap.put("actId", "__hGSekJLnneT6Vu9SYqs");
		contentMap.put("attitude", "123");
		contentMap.put("remark", "");

		String content = contentMap.toString();

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/forms/activities/batchApprove");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 /api/runtime/{applicationId}/documents/{docId}/activities/{actId}/executeAddress 接口<br/>
	 * 执行按钮的执行地址脚本
	 * @throws Exception
	 */
	@Test
	public void testExecuteAddress() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String id = "__hGSekJLnneT6Vu9SYqs";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		// 缓存里需要有对应的文档
		DocumentProcess dProcess = RunTimeServiceManager.documentProcess(
				application);
		Document doc = (Document) dProcess.doView(docid);
//		WebUser.setWebUser(webUser,session);
		MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, webUser);


		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + application + "/activities/" + id + "/executeAddress?docId="+docid);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

}

