package cn.myapps.rest;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;

import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.sequence.Sequence;

/**
 * @author Jarod
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = RuntimeWithConsulApp.class)
public class BpmRestTest extends AbstractControllerTests {

	private final static String applicationId = "__d6bNljtjwibGnwoqvGJ";
	private final static String userCode = "admin1";
	private final static String flowId = "__MoSbo1Kk9urMxC0FDhE";

	Cookie cookie;
	String adminId;
	String accessToken;
	String docid;

	@Before
	public void initUser() throws Exception {
		String username = "admin";
		String password = "teemlink";
		SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

		SuperUserVO user = sprocess.login(username, password);
		adminId = user.getId();
		accessToken = Security.getToken(user.getId());
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, accessToken);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");

		docid = Sequence.getSequence();
//		response.addCookie(cookie);
	}

	@Test
	public void getAcessToken() throws Exception {
		// 访问URL
		String url = "/rest/accessToken?secret=" + adminId;

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		// 返回结果
		resultActions.andDo(print());
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("success"));
	}

	/**
	 * 启动流程
	 * 
	 * @throws Exception
	 */
//	@Test
//	public void startFlow() throws Exception {
//		String url = "/rest/bpm/runtime/start?accessToken=" + accessToken
//				+ "&applicationId=__d6bNljtjwibGnwoqvGJ&userCode=admin1&flowId=__MoSbo1Kk9urMxC0FDhE";
//		// 构建请求
//		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(url);
//		JSONObject json = new JSONObject();
//		json.put("id", docid);
//		json.put("summary", "Demo流程测试");// summary
//		String content = json.toString();
////        json.put("items",form);
//		requestBuilder.content(content);
////        requestBuilder.cookie(cookie);
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//		resultActions.andDo(print());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("success"));
//	}

	@Test
	public void startAndSubmitFlow() throws Exception {
		String startUrl = "/rest/bpm/runtime/start?accessToken=" + accessToken + "&applicationId=" + applicationId
				+ "&userCode=" + userCode + "&flowId=" + flowId;
		// 开始流程
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(startUrl);
		JSONObject content = new JSONObject();
		content.put("id", docid);
		content.put("summary", "Demo流程测试");// summary
//        json.put("items",form);
		requestBuilder.content(content.toString());
//        requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andDo(print());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("success"));

		MvcResult result = resultActions.andReturn();
		String text = result.getResponse().getContentAsString();
		System.err.println(text);

		JSONObject jsonObj = JSONObject.parseObject(text);
		String instanceId = (String) JSONPath.eval(jsonObj, "$.data[0].instanceId");

		// 提交到下个节点
		String submissionUrl = "/rest/bpm/query/submission?accessToken=" + accessToken + "&applicationId="
				+ applicationId + "&userCode=" + userCode + "&flowId=" + flowId + "&instanceId=" + instanceId;
		requestBuilder = buildPostRequest(submissionUrl);
		requestBuilder.content(content.toString());
		resultActions = mockMvc.perform(requestBuilder);
		resultActions.andDo(print());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("success"));

		// 获取状态
		String statesUrl = "/rest/bpm/query/states?accessToken=" + accessToken + "&applicationId=" + applicationId
				+ "&instanceId=" + instanceId;
		requestBuilder = buildGetRequest(statesUrl);
		resultActions = mockMvc.perform(requestBuilder);
		resultActions.andDo(print());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("success"));
	}

}
