package cn.myapps.report.engine;

import static net.sf.dynamicreports.report.builder.DynamicReports.col;
import static net.sf.dynamicreports.report.builder.DynamicReports.report;
import static net.sf.dynamicreports.report.builder.DynamicReports.type;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import cn.myapps.runtime.report.model.DRDataSource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.Environment;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.designtime.report.service.ReportDesignTimeServiceImpl;
import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.templatedesign.JasperTemplateDesignReport1;
import cn.myapps.runtime.chart.service.ChartServiceImpl;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.sequence.Sequence;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperHtmlExporterBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;

import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRXmlDataSource;

@RunWith(SpringRunner.class)
@SpringBootTest(classes=RuntimeWithConsulApp.class)
public class ReportEngineTest {
	//static {
	//Environment.getInstance().setApplicationRealPath("D:/resources/");
	//Environment.getInstance().setContextPath("uploads");
	//}
	@Autowired
	private	ReportDesignTimeService service;

	@Test
	public void testBuild() throws Exception {
		ReportEngine engine = ReportEngine.getInstance();

		Report report = new Report();
		report.setId(Sequence.getSequence());
		report.setName("report test");
		report.setScriptTemplate("(function(){\r\n" +
				"	var FontBuilder = Packages.net.sf.dynamicreports.report.builder.style.FontBuilder;\r\n" +
				"var DynamicReports = Packages.net.sf.dynamicreports.report.builder.DynamicReports;\r\n" +
				"var Templates = Packages.cn.myapps.report.examples.Templates;\r\n" +
				"var TextColumnBuilder = Packages.net.sf.dynamicreports.report.builder.column.TextColumnBuilder;\r\n" +
				"var DRDataSource = Packages.net.sf.dynamicreports.report.datasource.DRDataSource;\r\n" +
				"var DRException = Packages.net.sf.dynamicreports.report.exception.DRException;\r\n" +
				"var JRDataSource = Packages.net.sf.jasperreports.engine.JRDataSource;\r\n" +
				"\r\n" +
				"var BigDecimal = Packages.java.math.BigDecimal;\r\n" +
				"var Integer = Packages.java.lang.Integer;\r\n" +
				"\r\n" +
				"function createDataSource() {\r\n" +
				"    var dataSource = new DRDataSource(\"item\", \"quantity\", \"unitprice\");\r\n" +
				"    dataSource.add(\"Tablet\", new Integer(350), new BigDecimal(300));\r\n" +
				"    dataSource.add(\"Laptop\", new Integer(300), new BigDecimal(500));\r\n" +
				"    dataSource.add(\"Smartphone\", new Integer(450), new BigDecimal(250));\r\n" +
				"    return dataSource;\r\n" +
				"}\r\n" +
				"\r\n" +
				"var boldFont = DynamicReports.stl.fontArialBold().setFontSize(12);\r\n" +
				"\r\n" +
				"        var itemColumn = DynamicReports.col.column(\"Item\", \"item\", DynamicReports.type.stringType());\r\n" +
				"        var quantityColumn = DynamicReports.col.column(\"Quantity\", \"quantity\", DynamicReports.type.integerType());\r\n" +
				"        var unitPriceColumn = DynamicReports.col.column(\"Unit price\", \"unitprice\", DynamicReports.type.bigDecimalType());\r\n" +
				"\r\n" +
				"return DynamicReports.report().setTemplate(Templates.reportTemplate)\r\n" +
				"		.columns(itemColumn, quantityColumn, unitPriceColumn)\r\n" +
				"		.title(Templates.createTitleComponent(\"AreaChart\"))\r\n" +
				"		.summary(DynamicReports.cht.areaChart()\r\n" +
				"					.setTitle(\"Area chart\")\r\n" +
				"					.setTitleFont(boldFont)\r\n" +
				"					.setCategory(itemColumn)\r\n" +
				"					.series(DynamicReports.cht.serie(quantityColumn), DynamicReports.cht.serie(unitPriceColumn))\r\n" +
				"					.setCategoryAxisFormat(DynamicReports.cht.axisFormat().setLabel(\"Item\")))\r\n" +
				"		.pageFooter(Templates.footerComponent)\r\n" +
				"		.setDataSource(createDataSource());\r\n" +
				"		\r\n" +
				"		\r\n" +
				"})();");

		ParamsTable params = new ParamsTable();
		WebUser user = new WebUser();

//		JasperHtmlExporterBuilder exporterBuilder = DynamicReports.export.htmlExporter("d:/report.html");

		engine.exportHtml(report, params, user);
//		builder.export(exporterBuilder);
	}

	@Test
	public void testBuild2() throws Exception {
		ReportEngine engine = ReportEngine.getInstance();

		Report printer = service.findById("dkjpHTpiPWTujbjKFOj");

		ParamsTable params = new ParamsTable();
		WebUser user = new WebUser();

		engine.exportHtml(printer, params, user);
	}


	//net.sf.jasperreports.engine.data.JRXmlDataSource

	/**
	 * 根据jrxml文件导出为pdf文件
	 * @throws Exception
	 */
	@Test
	public void testBuild3() throws Exception {
		try {
			ReportEngine engine = ReportEngine.getInstance();

			Report report = new Report();
			report.setId(Sequence.getSequence());
			report.setName("report test");
			ParamsTable params = new ParamsTable();
			WebUser user = new WebUser();

			DRDataSource dataSource = new DRDataSource("item", "quantity", "unitprice");
			for (int i = 0; i < 10; i++) {
				dataSource.add("Book", (int) (Math.random() * 10) + 1, (int) (Math.random() * 100) + 1);
			}

			List<ColumnBuilder> colms = new ArrayList<>();
			colms.add(col.column("Item", "item", (DRIDataType)DataTypes.detectType("java.lang.String")));//type.stringType()));
			colms.add(col.column("Quantity", "quantity", (DRIDataType)DataTypes.detectType("java.lang.Integer")));//type.integerType()));
			colms.add(col.column("Unit price", "unitprice", (DRIDataType)DataTypes.detectType("java.lang.Integer")));//type.integerType()));

			report.setTemplateType(Report.TYPE_JRXML);
			report.setJrxmlFilePath("D:/myapp_v4.2_workspace/trunk2018/obpm-demo/uploads/reports/templatedesign1.jrxml");
			report.setDrDataSource(dataSource);
			report.setReportColumnInfos(colms);

			engine.exportHtml(report, params, user);

		} catch (Exception e ) {
			e.printStackTrace();
		}

	}

}
