package cn.myapps.base;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.delete;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.patch;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.put;

import org.junit.Before;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import cn.myapps.conf.MyappsMvcConfig;



/**
 * Controller 测试抽象类，需要加载 {@link AppConfig},{@link MvcConfig} 类的配置，不使用 spring 进行事务管理。<br/>
 * 测试 Controller 需要加载 Servlet 上下文，因此添加了{@link WebAppConfiguration}注解<br/>
 * 需要测试的 Controller 类可以直接从此类继承
 * 
 * @author ahan
 *
 */
@WebAppConfiguration
@ContextConfiguration(classes = { MyappsMvcConfig.class})
public class AbstractControllerTests extends AbstractJUnit4SpringContextTests {

	protected MockMvc mockMvc;

	protected MockHttpSession session;

	protected MockHttpServletRequest request;

	/**
	 * 测试 Controller 需要用到 {@link MockMvc} 将其初始化
	 */
	@Before
	public void setupMockMvc() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext) applicationContext).build();
		session = new MockHttpSession();
		request = new MockHttpServletRequest();
	}

	/**
	 * 返回 MockMvcResultHandlers.print()
	 * @return
	 */
	protected ResultHandler print() {
		return MockMvcResultHandlers.print();
	}
	
	/**
	 * 统一构建get请求
	 * @param uri
	 * @return
	 */
	protected MockHttpServletRequestBuilder buildGetRequest(String uri) {
		return commonRequestHead(get(uri));
	}

	/**
	 * 统一构建post请求
	 * @param uri
	 * @return
	 */
	protected MockHttpServletRequestBuilder buildPostRequest(String uri) {
		return commonRequestHead(post(uri));
	}

	/**
	 * 统一构建delete请求
	 * @param uri
	 * @return
	 */
	protected MockHttpServletRequestBuilder buildDeleteRequest(String uri) {
		return commonRequestHead(delete(uri));
	}

	/**
	 * 统一构建patch请求
	 * @param uri
	 * @return
	 */
	protected MockHttpServletRequestBuilder buildPatchRequest(String uri) {
		return commonRequestHead(patch(uri));
	}

	/**
	 * 统一构建put请求
	 * @param uri
	 * @return
	 */
	protected MockHttpServletRequestBuilder buildPutRequest(String uri) {
		return commonRequestHead(put(uri));
	}

	/**
	 * 设置请求头和session
	 * @param builder
	 * @return
	 */
	private MockHttpServletRequestBuilder commonRequestHead(MockHttpServletRequestBuilder builder) {
		return builder.contentType(MediaType.APPLICATION_JSON_UTF8_VALUE).accept(MediaType.APPLICATION_JSON_UTF8_VALUE)
				.session(session);
	}
	
}
