package cn.myapps.authtime.workcalendar.calendar.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.authtime.workcalendar.calendar.model.CalendarVO;
import cn.myapps.run.RuntimeWithConsulApp;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

@RunWith(SpringRunner.class)
@SpringBootTest(classes=RuntimeWithConsulApp.class)
public class CalendarProcessBeanTest {

//	@Test
//	public void test() {
//		fail("Not yet implemented");
//	}
	
//	@Test
//	public void testDoQueryList() throws Exception {
//		CalendarProcess cp = new CalendarProcessBean();
//		ParamsTable params = new ParamsTable();
//		params.setParameter("domain", "3CffNlgt9B9StIjIUPB");
//		params.setParameter("sm_name", "");
////		DataPackage<CalendarVO> vo =cp.doQueryList(params);
////		System.out.println(vo.getDatas().size());
//	}
	
	@Test
	public void testDoQueryByHQL() throws Exception {
		CalendarProcess cp = new CalendarProcessBean();
		String hql = "from "+CalendarVO.class.getName()+" vo where vo.name=:standardCalendar  and vo.domainid= :domainid ";
		Map<String,Object> sqlParameterMap = new HashMap<String,Object>();
		sqlParameterMap.put("domainid","PM66k1DWyaUmMg9i3Xm");
		sqlParameterMap.put("standardCalendar", "��׼����");
		Collection<CalendarVO> vo = cp.doQueryByNameAndDomain("��׼����","PM66k1DWyaUmMg9i3Xm", 1, 1);
		//System.out.println("testDoQueryByHQL:"+vo.size());
	}

	/**
	 * 测试根据日历的名称获取日历对象
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过doViewByName()获取calendarvo对象
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testDoViewByName() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String calendarName = "标准日历测试";
		String domainid = "DIljHYOpEoinRW2L5Hz";
		CalendarVO cvo = (CalendarVO) calendarProcess.doViewByName(calendarName, domainid);
		assertEquals("预期值和实际值相同", calendarName,cvo.getName());
	}
	/**
	 * 测试根据日历类别calendar及起始日期与结束日期，统计出calendar日历中startDate与endDate之间多少天是工作日
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过countWorkingDays()获取相应的工作日
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testCountWorkingDays() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String start = "2017" +
				"-07-03 10:46:22";
		SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
		Date startDate = dateFormat.parse(start);
		//System.out.println(startDate);
		Date endDate = new Date();
		//String calendar = "Eight_TimeZone";
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		double a = calendarProcess.countWorkingDays(startDate, endDate, calendar);
		//System.out.println(a);
		assertTrue(a>0);
	}
	/**
	 * 测试根据日历类别calendar及年份月份，统计出calendar日历中year年month月有多少天是工作日
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过countWorkingDays()获取相应的工作日
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testCountWorkingDaysStringStringString() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String year = "2017";
		String month = "7";
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		double a = calendarProcess.countWorkingDays(year, month, calendar);
		//System.out.println(a);
		assertTrue(a>0);
	}
	/**
	 * 测试根据日历类别calendar及年份，统计出calendar日历中year年中有多少天是工作日
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过countWorkingDays()获取相应的工作日
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testCountWorkingDaysStringString() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String year = "2017";
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		double a = calendarProcess.countWorkingDays(year, calendar);
		//System.out.println(a);
		assertTrue(a>0);	//结果为double类型 断言为一个取值范围
	}
	/**
	 * 测试根据日历类别calendar及起始日期与结束日期，统计出calendar日历中startDate与endDate之间多少工作时间
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过countTimesOfWorkingDays()获取相应的工作日
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testCountTimesOfWorkingDays() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String start = "2017-07-03 10:46:22";
		SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
		Date startDate = dateFormat.parse(start);
		//System.out.println(startDate);
		Date endDate = new Date();
//		String calendar = "Eight_TimeZone";
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		double a = calendarProcess.countTimesOfWorkingDays(startDate, endDate, calendar);
		//System.out.println(a);
		assertTrue(a>0);	//结果为double类型 断言为一个取值范围
	}
	/**
	 * 测试通过domainid获取 calendarVo的集合
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过doQueryListByDomain()获取calendarVo集合
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testDoQueryListByDomain() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String domainid = "DIljHYOpEoinRW2L5Hz";
		Collection<CalendarVO> number = calendarProcess.doQueryListByDomain(domainid);
		//System.out.println(number.size());
		assertEquals("预期和实际值相同", 4 , number.size());
	}
	/**
	 * 测试获取全部的CalendarVO列表
	 * 1.设置参数
	 * 2.通过doQueryList()查询
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testDoQueryList() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
//		{_pagelines=10, domain=11e1-81e2-37f74759-9124-47aada6b7467, realPath=D:\apache-tomcat-7.0.78\webapps\obpm\}
		ParamsTable  params = new ParamsTable();
		Map<String, Object> map = (Map<String, Object>) params.getParams();
		map.put("_pagelines", 5);//分页获取每页显示的条数
		map.put("domain", "11e7-5f99-cc5d96f1-917f-e799edecb417");
		map.put("realPath", "D:/apache-tomcat-7.0.78/webapps/obpm/");
		DataPackage<CalendarVO> number =  calendarProcess.doQueryList(params);
		//System.out.println(number.linesPerPage);
		assertEquals("预期值和实际值相同", 1 , number.pageNo);
	}
	/**
	 * 测试获取下一天的时间(根据日历工作时段计算)
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过getNextDateByMinuteCount()获取下一天时间
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testGetNextDateByMinuteCount() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		Date currentDate = new Date();
		int minuteCount = 30;
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		Date nextTime = calendarProcess.getNextDateByMinuteCount(currentDate, minuteCount, calendar);
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		long curren = System.currentTimeMillis();
		curren += 30 * 60 * 1000;
		Date da = new Date(curren);
		System.out.println(dateFormat.format(nextTime));
		System.out.println(dateFormat.format(da));

	}
	/**
	 * 测试获取下一天的时间(根据日历工作时段计算)
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过getNextDate()获取下一天时间
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testGetNextDate() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		Date currentDate = new Date();
		int minuteCount = 30;
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		Date nextTime = calendarProcess.getNextDate(currentDate, minuteCount, calendar);
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		long curren = System.currentTimeMillis();
		curren += 30 * 60 * 1000;
		Date da = new Date(curren);
//		System.out.println(dateFormat.format(nextTime));
//		System.out.println(dateFormat.format(da));
	}
	/**
	 * 测试根据名称和domainid查询数据
	 * 1.从authtime_test数据库中t_calendar数据库获取相应到的数据参数
	 * 2.通过getCountByName()查询到几条数据
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testGetCountByName() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String name = "标准日历测试";
		String domainid = "DIljHYOpEoinRW2L5Hz";
		int a = calendarProcess.getCountByName(name, domainid);
		//System.out.println(a);
		assertEquals("预期值和实际值相同", 1 , a);
	}
	/**
	 * 测试更新操作
	 * 1.设置参数
	 * 2.通过DoUpdate()更新
	 * 3.通过getCountByName()查询对象
	 * 4.断言
	 * @throws Exception
	 */
	//@Test
	public void testDoUpdateStringStringString() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		String id = "ZKsRAyDrAP7u0NKPQdR";
		String name = "标准日历测试";//Standard_Calendar
		String remark = "标准日历测试";
		calendarProcess.doUpdate(id, name, remark);
		CalendarVO a = (CalendarVO) calendarProcess.doView(id);
		//System.out.println(a.getName());
		assertEquals("实际和预期值相同", name , a.getName());
	}
	/**
	 * 测试根据工作日历，判断当前时间currentDate是否为工作时间
	 * 1.设置需要的参数
	 * 2.通过IsWorkingTime()判断
	 * 3.断言
	 * @throws Exception
	 */
	@Test
	public void testIsWorkingTime() throws Exception {
		CalendarProcess calendarProcess = new CalendarProcessBean();
		Date currentDate = new Date();
		String calendar = "03acKF5X2gCdA1o3hsZ";//通过doView()获取的对象，只能通过唯一标识符获取，所以calendar设置参数为id
		boolean a = calendarProcess.isWorkingTime(currentDate, calendar);
		//System.out.println(a);
//		assertEquals("实际和预期值相同", a , true);
	}


}
