package cn.myapps.authtime.workcalendar.calendar.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class CalendarAuthtimeControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    @Test
    public void testGetCalendars() throws Exception {
        String domainid = "3CffNlgt9B9StIjIUPB";
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/calendars");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testUpdateCalendar() throws Exception {
        String domainid = "3CffNlgt9B9StIjIUPB";
        String content = "{\n" +
                "\n" +
                "\"_calendarid\": \"MvdoAhyBO3YoaulPvvs1\",\n" +
                "\n" +
                "\"name\": \"1121211212\",\n" +
                "\n" +
                "\"remark\": \"112\"\n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/calendar/MvdoAhyBO3YoaulPvvs1");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testAddAndDeleteCalendar() throws Exception {
        String domainid = "3CffNlgt9B9StIjIUPB";
        String content = "{\n" +
                "\n" +
                "\"_calendarid\": \"qCv88TplkcYoiGxMhJ8\",\n" +
                "\n" +
                "\"name\": \"1qw2e22wq\",\n" +
                "\n" +
                "\"remark\": \"111212212911122\"\n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain/"+domainid+"/calendar");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

//        CalendarProcess calendarProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
//        CalendarVO calendarVO = calendarProcess.doQueryByCalendarId("Cr2CjiS8YHmyeudRuek");
//
//        requestBuilder = buildDeleteRequest(
//                "/api/authtime/calendar");
//        String content2 = "[\n" +
//                "    \""+calendarVO.getId()+"\"\n" +
//                "]";
//        requestBuilder.content(content2);
//        resultActions = mockMvc.perform(requestBuilder);
//
//        resultActions.andExpect(status().isOk());
//        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//        resultActions.andExpect(jsonPath("$.errcode").value(0));
//        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}
