package cn.myapps.authtime.usergroup.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.usergroup.model.UserGroupVO;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.sequence.Sequence;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Collection;
import java.util.Iterator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

@RunWith(SpringRunner.class)
@SpringBootTest(classes=RuntimeWithConsulApp.class)
public class UserGroupProcessBeanTest {

	@Test
	public void testGetUserGroupsByUser() throws Exception {
		UserGroupProcess ugprocess =new UserGroupProcessBean();

		UserGroupVO ugvo=new UserGroupVO();
		ugvo.setId(Sequence.getSequence());
		ugvo.setName("group one");
		ugvo.setOwnerId(Sequence.getSequence());

		//初始化DomainVO,以获取Domainid
		DomainVO dvo=new DomainVO();
		dvo.setId(Sequence.getSequence());
		dvo.setName("my company2");
		ugprocess.doCreate(ugvo);


		//测试根据用户返回用户的组信息
		DataPackage<UserGroupVO> dp=ugprocess.getUserGroupsByUser("2TE7lzsbdyqLhndabbN");
		//获取当前页面的条数
		Collection<UserGroupVO> datas = dp.getDatas();
		assertTrue(!datas.isEmpty());
		Iterator<UserGroupVO> iterator=datas.iterator();
		while(iterator.hasNext()){
			UserGroupVO po=iterator.next();
			assertTrue(ugvo.getOwnerId() != null);
		}

		//测试根据分组名和用户ID查询是否已存在分组
		boolean flag=ugprocess.isExistGroup(ugvo.getName(), ugvo.getOwnerId());
		assertEquals(flag,true);

		//测试删除用户分组
		ugprocess.deleteGroup(ugvo.getId());
	}

}
