package cn.myapps.authtime.user.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.application.Application;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.sequence.Sequence;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class UserProcessBeanTest {
	public UserVO user;

	@Test
	public void testDoCreateValueObjectAndAndRemove() throws Exception{
		Random random = new Random();
		int s = random.nextInt(99999);
		user = new UserVO();
		user.setId(Sequence.getSequence());
		user.setName("UserName" + Sequence.getSequence());
		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
		user.setLoginno("Loginno" + s);
		user.setLoginpwd("123456");
		// user.setPasswordArray("123456");
		user.setDomainid("3CffNlgt9B9StIjIUPB");
		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
		user.setDomainAdmin(true);
		UserProcess userProcess = new UserProcessBean();
		userProcess.doCreate(user);
		userProcess.doRemove(user.getId());
	}

	@Test
	public void testDoUpdateValueObject() throws Exception{
		Random random = new Random();
		int s = random.nextInt(99999);
		user = new UserVO();
		user.setId("zFRmV4O7QHEvJT9XltP");
		user.setName("UserName" + Sequence.getSequence());
		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
		user.setLoginno("Loginno" + s);
		user.setLoginpwd("123456");
		// user.setPasswordArray("123456");
		user.setDomainid("3CffNlgt9B9StIjIUPB");
		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
		user.setDomainAdmin(true);
		UserProcess userProcess = new UserProcessBean();
		userProcess.doUpdate(user);
	}

	@Test
	public void testDoCreateWithoutPW() throws Exception{
		Random random = new Random();
		int s = random.nextInt(99999);
		user = new UserVO();
		user.setId(Sequence.getSequence());
		user.setName("UserName" + Sequence.getSequence());
		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
		user.setLoginno("Loginno" + s);
		user.setLoginpwd("123456");
		// user.setPasswordArray("123456");
		user.setDomainid("3CffNlgt9B9StIjIUPB");
		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
		user.setDomainAdmin(true);
		UserProcess userProcess = new UserProcessBean();
		userProcess.doCreateWithoutPW(user,true);
		userProcess.doRemove(user.getId());
	}

	@Test
	public void testDoUpdateDefaultApplication() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		userProcess.doUpdateDefaultApplication("zFRmV4O7QHEvJT9XltP","HdPeBqYwJyFyjHkhZu3");
	}

	@Test
	public void testDoUpdateWithCache() throws Exception{
		Random random = new Random();
		int s = random.nextInt(99999);
		user = new UserVO();
	    user.setId("zFRmV4O7QHEvJT9XltP");
		user.setName("UserName" + Sequence.getSequence());
		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
		user.setLoginno("Loginno" + s);
		user.setLoginpwd("123456");
		// user.setPasswordArray("123456");
		user.setDomainid("3CffNlgt9B9StIjIUPB");
		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
		user.setDomainAdmin(true);
		UserProcess userProcess = new UserProcessBean();
		userProcess.doUpdateWithCache(user);
		userProcess.doPersonalUpdate(user);
		userProcess.doRemove(user.getId());
	}

	@Test
	public void testGetUnderListString() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		userProcess.getUnderList("zFRmV4O7QHEvJT9XltP");
	}

	@Test
	public void testGetSuperiorList() throws Exception{

	}

	@Test
	public void testChangePwd() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		userProcess.changePwd("YpfsRofkksTJlMBoOgD","123456","123456");
	}

	@Test
	public void testLoginString() throws Exception {
		UserProcess userProcess = new UserProcessBean();
		UserVO vo = userProcess.login("admin1");
		//System.out.println(vo.getLoginno());
	}

//	@Test
//	public void testGetDatasByDeptStringString() throws Exception{
//		UserProcess userProcess = new UserProcessBean();
//		Collection<UserVO> userVOS = userProcess.getDatasByDept("5fbaLCe8DIbIP2BdQoc","3CffNlgt9B9StIjIUPB");
//		//System.out.println(userVOS.size());
//		Collection<UserVO> userVOS2 = userProcess.getDatasByDept("3nvysoo7nWKoxp0FShm");
//		//System.out.println(userVOS2.size());
//
//	}

//	@Test
//	public void testGetDatasByGroup() throws Exception{
//		UserProcess userProcess = new UserProcessBean();
//		Collection<UserVO> userVOS = userProcess.getDatasByGroup("11e8-5e5c-6a1a237d-b84a-39be571b3c90","3CffNlgt9B9StIjIUPB");
//		System.out.println(userVOS.size());
//	}

//	@Test
//	public void testDoPersonalUpdate() throws Exception{
//		Random random = new Random();
//		int s = random.nextInt(99999);
//		user = new UserVO();
//		user.setId("zFRmV4O7QHEvJT9XltP");
//		user.setName("UserName" + Sequence.getSequence());
//		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
//		user.setLoginno("Loginno" + s);
//		user.setLoginpwd("123456");
//		// user.setPasswordArray("123456");
//		user.setDomainid("3CffNlgt9B9StIjIUPB");
//		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
//		user.setDomainAdmin(true);
//		UserProcess userProcess = new UserProcessBean();
//		userProcess.doPersonalUpdate(user);
//		userProcess.doRemove(user.getId());
//	}

	@Test
	public void testCreateUser() throws Exception{
		Random random = new Random();
		int s = random.nextInt(99999);
		user = new UserVO();
		user.setId(Sequence.getSequence());
		user.setName("UserName" + Sequence.getSequence());
		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
		user.setLoginno("Loginno" + s);
		user.setLoginpwd("123456");
		// user.setPasswordArray("123456");
		user.setDomainid("3CffNlgt9B9StIjIUPB");
		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
		user.setDomainAdmin(true);
		UserProcess userProcess = new UserProcessBean();
		userProcess.createUser(user);
		userProcess.doRemove(user.getId());
	}

	@Test
	public void testDoQueryByRoleId() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		DataPackage<UserVO> userVODataPackage = userProcess.doQueryByRoleId("11e8-5e5c-6a1a237d-b84a-39be571b3c90");
		//System.out.println(userVODataPackage.datas);
	}

	@Test
	public void testQueryByDomainString() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		DataPackage<UserVO> userVODataPackage = userProcess.doQueryByDoaminAnddefaultDeptLikeName("3CffNlgt9B9StIjIUPB",
				"febFF7bdzJJ0HJyh3dc","admin1",1,10);
//		System.out.println(userVODataPackage.datas);
		DataPackage<UserVO> userVODataPackage2 = userProcess.doQueryByDoaminaAndStatusAndPermissionType("3CffNlgt9B9StIjIUPB",
				"public",1,1,10);
		DataPackage<UserVO> userVODataPackage3 = userProcess.doQueryByDomainAndLikeName("3CffNlgt9B9StIjIUPB",
				"admin1",1,10);
		DataPackage<UserVO> userVODataPackage4 = userProcess.doQueryByDomainAndOrderByNameLetter("3CffNlgt9B9StIjIUPB",
				"admin1",1,10);
		DataPackage<UserVO> userVODataPackage5 = userProcess.doQueryByDomainAndDefaultDepartment("3CffNlgt9B9StIjIUPB",
				"5fbaLCe8DIbIP2BdQoc",1,10);
		Collection<UserVO> userVODataPackage6 = userProcess.doQueryByDomainAndTel("154562382650900000",
				"3CffNlgt9B9StIjIUPB");

	}


	@Test
	public void testQueryByProxyUserId() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVODataPackage6 = userProcess.queryByProxyUserId("TyigJ70RRrysfm2FcmP");
	}

	@Test
	public void testGetDefaultApplicationId() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		String a = userProcess.getDefaultApplicationId("zPsp2hk7CEwtqeMCwtj");
	}

	@Test
	public void testGetUserByLoginno() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		UserVO userVO = userProcess.getUserByLoginno("admin1","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testFindByTelephone() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		UserVO userVO = userProcess.findByTelephone("12345678901","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testFindByEmail() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		UserVO userVO = userProcess.findByEmail("903414094@qq.com","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testGetUserByLoginnoAndDoaminName() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		UserVO userVO = userProcess.getUserByLoginnoAndDoaminName("admin1","测试");
	}

	@Test
	public void testQueryUserIdsByName() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		String userVO = userProcess.queryUserIdsByName("卢何山","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testFindUserIdByAccountStringString() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		String userVO = userProcess.findUserIdByAccount("admin1","3CffNlgt9B9StIjIUPB");
		String userVO2 = userProcess.findUserIdByAccount("admin1");
	}

	@Test
	public void testQueryByDepartmentString() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVO = userProcess.queryByDepartment("5fbaLCe8DIbIP2BdQoc");
		Collection<UserVO> userVO2 = userProcess.queryByDepartment("5fbaLCe8DIbIP2BdQoc",true);
	}

	@Test
	public void testQueryOutOfDepartment() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVO = userProcess.queryByDepartment("5fbaLCe8DIbIP2BdQoc");
	}

	@Test
	public void testQueryOutOfRole() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		DataPackage<UserVO> userVO = userProcess.queryOutOfRole("HdPeBqYwJyFyjHkhZu3","public","11de-9872-923f2932-a237-5125ae7dccdf",1,10);
	}

	@Test
	public void testAddUserToDept() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		userProcess.addUserToDept(new String[]{"zQG58rY0MNgj6WzFm1F"},"5fbaLCe8DIbIP2BdQoc");
	}

//	@Test
//	public void testAddUserToRole() throws Exception{
//		UserProcess userProcess = new UserProcessBean();
//		userProcess.addUserToRole(new String[]{"zQG58rY0MNgj6WzFm1F"},"11e8-5e5c-6a1a237d-b84a-39be571b3c90");
//	}

	@Test
	public void testQueryByRole() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVOS = userProcess.queryByRole("11de-a3fb-82a36b38-b780-195d0cfca836");
	}

	@Test
	public void testQueryByRoleAndDomain() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVOS = userProcess.queryByRoleAndDomain("11de-a3fb-82a36b38-b780-195d0cfca836","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testUpdateUserLockFlag() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		userProcess.updateUserLockFlag("admin1",1);
	}

	@Test
	public void testDoBatchCreate() throws Exception{
		Random random = new Random();
		int s = random.nextInt(99999);
		Collection<UserVO> users = new ArrayList<>();
		user = new UserVO();
		user.setId(Sequence.getSequence());
		user.setName("UserName" + Sequence.getSequence());
		user.setEmail("test" + Sequence.getSequence() + "@teemlink.com");
		user.setLoginno("Loginno" + s);
		user.setLoginpwd("123456");
		// user.setPasswordArray("123456");
		user.setDomainid("3CffNlgt9B9StIjIUPB");
		user.setDefaultDepartment("3nvysoo7nWKoxp0FShm");
		user.setDomainAdmin(true);
		users.add(user);
		UserProcess userProcess = new UserProcessBean();
		userProcess.doBatchCreate(users);
	}

	@Test
	public void testQueryForUserDialog() throws Exception{
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) uProcess.doView(userid);
		WebUser webUser = new WebUser(user);
		UserProcess userProcess = new UserProcessBean();
		userProcess.queryForUserDialog("3CffNlgt9B9StIjIUPB","测试",webUser,"GSpVBQXBXPaV8XSOl2T",
				1,10);
	}

	@Test
	public void testQueryByDeptForUserDialog() throws Exception{
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) uProcess.doView(userid);
		WebUser webUser = new WebUser(user);
		UserProcess userProcess = new UserProcessBean();
		userProcess.queryByDeptForUserDialog("3CffNlgt9B9StIjIUPB","3CffNlgt9B9StIjIUPB","测试",webUser,"GSpVBQXBXPaV8XSOl2T",
				1,10);
	}

	@Test
	public void testQueryByRoleForUserDialog() throws Exception{
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) uProcess.doView(userid);
		WebUser webUser = new WebUser(user);
		UserProcess userProcess = new UserProcessBean();
		userProcess.queryByRoleForUserDialog("3CffNlgt9B9StIjIUPB",webUser,"GSpVBQXBXPaV8XSOl2T",
				1,10);
	}

	@Test
	public void testGetCountsByDepartment() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Long a = userProcess.getCountsByDepartment("5fbaLCe8DIbIP2BdQoc");
	}

//	@Test
//	public void testGetCountsByRole() throws Exception{
//		UserProcess userProcess = new UserProcessBean();
//		Long a = userProcess.getCountsByRole("11e8-5e5c-6a1a237d-b84a-39be571b3c90");
//	}

	@Test
	public void testGetCountsByRoleAndDomain() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Long a = userProcess.getCountsByRoleAndDomain("11e8-5e5c-6a1a237d-b84a-39be571b3c90","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testQueryUsersByNameLoginnoDeptDomain() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVOS = userProcess.queryUsersByNameLoginnoDeptDomain("","5fbaLCe8DIbIP2BdQoc","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testFindUserIdByAccountString() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		String a = userProcess.findUserIdByAccount("admin1");
	}

	@Test
	public void testQueryByFuzzy() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVOS = userProcess.queryByFuzzy("admin1","3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testQueryByUserIds() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> userVOS = userProcess.queryByUserIds(new String[]{"rQfMeQJdjHQys5hZ85N"},"3CffNlgt9B9StIjIUPB");
	}

	@Test
	public void testQueryByFirstLetter() throws Exception {
		UserProcess userProcess = new UserProcessBean();
		Collection<UserVO> vo = userProcess.queryByFirstLetter("ln", "2CqnTkYeIBIDxlaro7f");
		//System.out.println(vo.size());
	}

	@Test
	public void testQueryRoleIdsByUserId() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<String> strings = userProcess.queryRoleIdsByUserId("rQfMeQJdjHQys5hZ85N");
	}

//	@Test
//	public void testGetDefaultApplication() throws Exception{
//		String userid = "zPsp2hk7CEwtqeMCwtj";
//		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		WebUser webUser = new WebUser(user);
//		UserProcess userProcess = new UserProcessBean();
//		Application a = userProcess.getDefaultApplication("HdPeBqYwJyFyjHkhZu3",webUser);
//	}

	@Test
	public void testQueryUserDepartmentRoleSetsByUserId() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		Collection<UserDepartmentRoleSet> strings = userProcess.queryUserDepartmentRoleSetsByUserId("rQfMeQJdjHQys5hZ85N");
	}

	@Test
	public void testQueryUserByRoleId() throws Exception{
		UserProcess userProcess = new UserProcessBean();
		DataPackage<UserVO> strings = userProcess.queryUserByRoleId("11df-64b5-5240f0f2-98bb-7d655f3a689a",1,10);
	}

}
