package cn.myapps.authtime.user.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class UserAuthtimeControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    @Test
    public void doList() throws Exception {
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        params.add("username","");
        params.add("currpage","1");
        params.add("pagelines","10");
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/3CffNlgt9B9StIjIUPB/users");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

    }

    @Test
    public void getUser() throws Exception {
        create();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO vo = userProcess.login("ekko10","3CffNlgt9B9StIjIUPB");
        MockHttpServletRequestBuilder requestBuilder1 = buildGetRequest(
                "/api/authtime/user/"+vo.getId());
//        requestBuilder.params(params);
        requestBuilder1.cookie(cookie);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);
        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));
        delete();
    }

    @Test
    public void getRoleWithDeptAndKMRelation() throws Exception {
        create();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO vo = userProcess.login("ekko10","3CffNlgt9B9StIjIUPB");
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/user/"+vo.getId()+"/rolewithdeptandkmrelation");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        delete();

    }

    @Test
    public void doCreateUser() throws Exception{
        create();
        delete();

    }

    @Test
    public void doUpdateUser() throws Exception {
        create();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO vo = userProcess.login("ekko10","3CffNlgt9B9StIjIUPB");
        String domainid = "3CffNlgt9B9StIjIUPB";
        String content ="{\n" +
                "\n" +
                "    \"name\": \"ekko10\",\n" +
                "\n" +
                "    \"loginno\": \"ekko10\",\n" +
                "    \n" +
                "    \"loginpwd\":\"IzNDU2MT\",\n" +
                "\n" +
                "    \"email\": \"emai1l@teemlink.com\",\n" +
                "\n" +
                "    \"emailPublic\": true,\n" +
                "\n" +
                "    \"telephone\": \"13192286346\",\n" +
                "\n" +
                "    \"telephonePublic\": true,\n" +
                "\n" +
                "    \"calendarType\": \"i7xj207zBMEwBp8aATE\",\n" +
                "\n" +
                "    \"calendarTypeName\": \"夜班日历\",\n" +
                "\n" +
                "    \"telephone2\": \"13192286349\",\n" +
                "\n" +
                "    \"telephonePublic2\": true,\n" +
                "\n" +
                "    \"reportTree\": \"\",\n" +
                "\n" +
                "    \"superiorid\": \"\",\n" +
                "\n" +
                "    \"_proxyUser\": \"\",\n" +
                "\n" +
                "    \"remarks\": \"\",\n" +
                "\n" +
                "    \"startProxyTime\": \"\",\n" +
                "\n" +
                "    \"endProxyTime\": \"\",\n" +
                "\n" +
                "    \"permissionType\": \"public\",\n" +
                "\n" +
                "    \"lockFlag\": 1,\n" +
                "    \n" +
                "    \"status\":1,\n" +
                "\n" +
                "    \"defaultDepartment\": \"Z42xU8LmniRouZ93E7s\",\n" +
                "\n" +
                "\n" +
                "    \"_userRoleDepartmentJson\":'[{\"roleId\":\"3tFw1boS5L9vXoJCr6Z\",\"departmentId\":\"Z42xU8LmniRouZ93E7s\",\"applicationId\":\"HdPeBqYwJyFyjHkhZu3\",\"isDefaultDepartment\":\"true\"}]',\n" +
                "\n" +
                "    \"_userKMRoleJson\": '[\"0001\"]',\n" +
                "\n" +
                "    \"_kmRoleJson\":'[{\"id\":\"0020\",\"name\":\"专委会知识管理员\",\"level\":\"20\"},{\"id\":\"0100\",\"name\":\"企业知识管理员\",\"level\":\"10\"},{\"id\":\"0001\",\"name\":\"员工\",\"level\":\"0\"},{\"id\":\"0010\",\"name\":\"部门知识管理员\",\"level\":\"10\"}]',\n" +
                "\n" +
                "    \"_kmRole\": '[]'\n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/user/"+vo.getId());
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        delete();

    }

    @Test
    public void doDeleteUser () throws Exception {
        create();
        delete();
    }

    @Test
    public void getDepartmentUsers() throws Exception{
        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DepartmentVO dvo = departmentProcess.getRootDepartmentByDomainId("3CffNlgt9B9StIjIUPB");
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/department/"+dvo.getId()+"/users");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void checkNickname() {
    }

    public  void  create() throws Exception{
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        String domainid = "3CffNlgt9B9StIjIUPB";
        String content ="{\n" +
                "\n" +
                "    \"name\": \"ekko10\",\n" +
                "\n" +
                "    \"loginno\": \"ekko10\",\n" +
                "    \n" +
                "    \"loginpwd\":\"IzNDU2MT\",\n" +
                "\n" +
                "    \"email\": \"email@teemlink.com\",\n" +
                "\n" +
                "    \"emailPublic\": true,\n" +
                "\n" +
                "    \"telephone\": \"13192286346\",\n" +
                "\n" +
                "    \"telephonePublic\": true,\n" +
                "\n" +
                "    \"calendarType\": \"i7xj207zBMEwBp8aATE\",\n" +
                "\n" +
                "    \"calendarTypeName\": \"夜班日历\",\n" +
                "\n" +
                "    \"telephone2\": \"13192286349\",\n" +
                "\n" +
                "    \"telephonePublic2\": true,\n" +
                "\n" +
                "    \"reportTree\": \"\",\n" +
                "\n" +
                "    \"superiorid\": \"\",\n" +
                "\n" +
                "    \"proxyUserid\": \"\",\n" +
                "\n" +
                "    \"remarks\": \"\",\n" +
                "\n" +
                "    \"startProxyTime\": \"\",\n" +
                "\n" +
                "    \"endProxyTime\": \"\",\n" +
                "\n" +
                "    \"permissionType\": \"public\",\n" +
                "\n" +
                "    \"lockFlag\": 1,\n" +
                "    \n" +
                "    \"status\":1,\n" +
                "\n" +
                "    \"defaultDepartment\": \"Z42xU8LmniRouZ93E7s\",\n" +
                "\n" +
                "\n" +
                "    \"_userRoleDepartmentJson\":'[{\"roleId\":\"3tFw1boS5L9vXoJCr6Z\",\"departmentId\":\"Z42xU8LmniRouZ93E7s\",\"applicationId\":\"HdPeBqYwJyFyjHkhZu3\",\"isDefaultDepartment\":\"true\"}]',\n" +
                "\n" +
                "    \"_userKMRoleJson\": '[\"0001\"]',\n" +
                "\n" +
                "    \"_kmRoleJson\":'[{\"id\":\"0020\",\"name\":\"专委会知识管理员\",\"level\":\"20\"},{\"id\":\"0100\",\"name\":\"企业知识管理员\",\"level\":\"10\"},{\"id\":\"0001\",\"name\":\"员工\",\"level\":\"0\"},{\"id\":\"0010\",\"name\":\"部门知识管理员\",\"level\":\"10\"}]',\n" +
                "\n" +
                "    \"_kmRole\": '[]'\n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain/"+domainid+"/user");
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isCreated());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    public void  delete() throws Exception{
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO vo = userProcess.login("ekko10","3CffNlgt9B9StIjIUPB");
        MockHttpServletRequestBuilder requestBuilder1 = buildDeleteRequest(
                "/api/authtime/user");
//        requestBuilder.params(params);
        String content ="[\""+vo.getId()+"\"]";
        requestBuilder1.cookie(cookie);
        requestBuilder1.content(content);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);
        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}