package cn.myapps.authtime.systemconfig.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class SysConfigControllerTest extends AbstractControllerTests {
    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    @Test
    public void testGetConfig() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/config");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testUpdateConfig() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/config");
        String content = "{\n" +
                "\t\"data\":{\n" +
                "\t  \t\"authConfig\":{\n" +
                "\t\t\t\"adDefaultDomain\": \"\",\n" +
                "\t\t\t\"adDomainController\": \"\",\n" +
                "\t\t\t\"adadminloginno\": \"\",\n" +
                "\t\t\t\"adadminloginnopw\": \"\",\n" +
                "\t\t\t\"adjespapassword\": \"\",\n" +
                "\t\t\t\"adjespausernmae\": \"\",\n" +
                "\t\t\t\"adlogindomain\": \"\",\n" +
                "\t\t\t\"authType\": \"default\",\n" +
                "\t\t\t\"casLoginUrl\": \"http://localhost:8080/obpm-cas/login\",\n" +
                "\t\t\t\"casUrlPrefix\": \"http://localhost:8080/obpm-cas\",\n" +
                "\t\t\t\"ldaptLogin\": false,\n" +
                "\t\t\t\"localServerName\": \"localhost:8080\",\n" +
                "\t\t\t\"loginAuth\": \"cn.myapps.security.sso.autherticator.DefaultLoginAuthenticator\",\n" +
                "\t\t\t\"smsAffectMode\": \"all\",\n" +
                "\t\t\t\"smsAuthenticate\": \"false\",\n" +
                "\t\t\t\"smsContent\": \"您正在登陆myApps管理平台，请确认输入短信校验码：$后才能登陆系统。详询020-383804\",\n" +
                "\t\t\t\"smsEndRangeIp\": \"192.168.0.255\",\n" +
                "\t\t\t\"smsStartRangeIp\": \"192.168.0.1\",\n" +
                "\t\t\t\"smsTimeout\": \"100\",\n" +
                "\t\t\t\"ssoAuth\": \"cn.myapps.security.sso.CasUserSSO\",\n" +
                "\t\t\t\"ssoDataEncryption\": \"base64\",\n" +
                "\t\t\t\"ssoDefaultEmail\": \"sso@user\",\n" +
                "\t\t\t\"ssoDefaultPassword\": \"sso\",\n" +
                "\t\t\t\"ssoKeyDomain\": \"obpmDomainName\",\n" +
                "\t\t\t\"ssoKeyEmail\": \"obpmUserEmail\",\n" +
                "\t\t\t\"ssoKeyLoginAccount\": \"obpmLoginAccount\",\n" +
                "\t\t\t\"ssoKeyPassword\": \"obpmLoginPassword\",\n" +
                "\t\t\t\"ssoLogoutRedirect\": \"http://localhost:8080/obpm-cas/logout\",\n" +
                "\t\t\t\"ssoRedirect\": \"http://localhost:8080/signon/login/sso\",\n" +
                "\t\t\t\"ssoSaveType\": \"cookie\",\n" +
                "\t\t\t\"usbkeyAffectMode\": \"all\",\n" +
                "\t\t\t\"usbkeyAuthenticate\": \"false\",\n" +
                "\t\t\t\"usbkeyRangeIps\": \"[{startIP:'192.168.0.1',endIP:'192.168.0.100'},]\"\n" +
                "\t\t},\n" +
                "\t\t  \"checkoutConfig\":{\n" +
                "\t\t  \t\n" +
                "\t\t  },\n" +
                "\t\t\t\"hxImConfig\":{\n" +
                "\t\t\t\t\"app_name\": \"com-tlin-jarod-tlin\",\n" +
                "\t\t\t\t\"client_id\": \"YXA6kqOBEMNtEeeKPC1YpoCz-A\",\n" +
                "\t\t\t\t\"client_secret\": \"YXA6-2HmjGsEQutF62F5CviM4jqWsVo\",\n" +
                "\t\t\t\t\"grant_type\": \"client_credentials\",\n" +
                "\t\t\t\t\"open\": \"0\",\n" +
                "\t\t\t\t\"org_name\": \"1180171101178675\"\n" +
                "\t\t\t},\n" +
                "\t\t\t\"imConfig\":{\n" +
                "\t\t\t\t\"ip\": \"\",\n" +
                "\t\t\t\t\"loginno\": \"\",\n" +
                "\t\t\t\t\"open\": \"\",\n" +
                "\t\t\t\t\"password\": \"\",\n" +
                "\t\t\t\t\"port\": \"\"\n" +
                "\t\t\t},\n" +
                "\t\t\t\"ldapConfig\":{\n" +
                "\t\t\t\t\"baseDN\": \"dc=teemlink,dc=com\",\n" +
                "\t\t\t\t\"deptClass\": \"organizationalUnit\",\n" +
                "\t\t\t\t\"dirStructure\": \"uid=?,ou=user,o=?\",\n" +
                "\t\t\t\t\"domain\": \"demo1\",\n" +
                "\t\t\t\t\"email_\": \"mail\",\n" +
                "\t\t\t\t\"enterDept\": \"ou=ceshi\",\n" +
                "\t\t\t\t\"id_\": \"entryUUID\",\n" +
                "\t\t\t\t\"loginno_\": \"userprincipalname\",\n" +
                "\t\t\t\t\"loginpwd_\": \"userPassword\",\n" +
                "\t\t\t\t\"manager\": \"cn=Administrator,cn=Users,dc=teemlink,dc=com\",\n" +
                "\t\t\t\t\"managerPassword\": \"teemlink\",\n" +
                "\t\t\t\t\"name_\": \"cn\",\n" +
                "\t\t\t\t\"pooled\": \"true\",\n" +
                "\t\t\t\t\"telephone_\": \"telephoneNumber\",\n" +
                "\t\t\t\t\"url\": \"ldap://192.168.0.132:389/dc=teemlink,dc=com\",\n" +
                "\t\t\t\t\"userClass\": \"organizationalPerson\",\n" +
                "\t\t\t\t\"validBaseDN\": \"false\",\n" +
                "\t\t\t\t\"validDirStructure\": \"true\"\n" +
                "\t\t\t},\n" +
                "\t\t\t\"loginConfig\":{\n" +
                "\t\t\t\t\"failLoginTimes\": \"20\",\n" +
                "\t\t\t\t\"legal\": \"0\",\n" +
                "\t\t\t\t\"length\": \"6\",\n" +
                "\t\t\t\t\"maxAge\": \"60\",\n" +
                "\t\t\t\t\"maxUpdateTimes\": \"10\",\n" +
                "\t\t\t\t\"noticeAuthor\": \"1\",\n" +
                "\t\t\t\t\"noticeContent\": \"欢迎使用myApps平台\",\n" +
                "\t\t\t\t\"noticeMethod\": \"1\",\n" +
                "\t\t\t\t\"noticeTime\": \"45\"\n" +
                "\t\t\t}\n" +
                "\t\t\t\t  \n" +
                "\t}\n" +
                "}\n";
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("保存成功"));
    }

    @Test
    public void testExportSysConfig() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/config");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testClearDatas() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/config/cleardatas");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testClearCache() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/config/clearcache");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

//    @Test
//    public void testSynUsersToHx() throws Exception {
//        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
//                "/api/authtime/config/userstohx");
//        requestBuilder.cookie(cookie);
//        ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//        resultActions.andExpect(status().isOk());
//        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//        resultActions.andExpect(jsonPath("$.errcode").value(0));
//        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//    }
}
