package cn.myapps.authtime.superuser.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class SuperuserControllerTest extends AbstractControllerTests {
    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    @Test
    public void testGetSuperuserList() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/superuser?name=&loginno=&currpage=1&pagelines=10");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testAddAndUpdateAndDeleteSuperuserList() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/superuser");
        String content1 = "{\n" +
                "\n" +
                "    \"name\": \"admin13\",\n" +
                "\n" +
                "    \"loginno\": \"admin13\",\n" +
                "\n" +
                "    \"password\": \"123456\",\n" +
                "\n" +
                "    \"email\": \"2079119400@qq.com\",\n" +
                "\n" +
                "    \"status\": 1,\n" +
                "\n" +
                "    \"issuperadmin\": \"true\",\n" +
                "\n" +
                "    \"functionDomain\": \"true\"\n" +
                "\n" +
                "}";
        requestBuilder.cookie(cookie);
        requestBuilder.content(content1);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        SuperUserDesignTimeService process = DesignTimeServiceManager.superUserDesignTimeService();
        SuperUserVO superUserVO = process.doViewByLoginno("admin13");

        requestBuilder = buildPutRequest(
                "/api/authtime/superuser/"+superUserVO.getId());
        String content2 = "{\n" +
                "\n" +
                "    \"name\": \"admin13\",\n" +
                "\n" +
                "    \"loginno\": \"admin13\",\n" +
                "\n" +
                "    \"password\": \"123456\",\n" +
                "\n" +
                "    \"email\": \"2079119400@qq.com\",\n" +
                "\n" +
                "    \"status\": 1,\n" +
                "\n" +
                "    \"issuperadmin\": \"true\",\n" +
                "\n" +
                "    \"functionDomain\": \"true\"\n" +
                "\n" +
                "}";
        requestBuilder.cookie(cookie);
        requestBuilder.content(content2);
        resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        requestBuilder = buildDeleteRequest(
                "/api/authtime/superuser");
        String content3 = "[\n" +
                "    \""+superUserVO.getId()+"\"\n" +
                "]";

        requestBuilder.cookie(cookie);
        requestBuilder.content(content3);
        resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

    }

}
