package cn.myapps.authtime.flow.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class FlowInterventionControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();
        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    /**
     * 查询流程监控列表
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetFlowstatertList() throws Exception {
        String domainid = "uumsxrgm1KEEqSZIoHs";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        params.add("application", "sOZu9kthmxyP8qQfq0e");
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/workflow/flowstaterts");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 查看流程实例信息
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetFlowstatert() throws Exception{
//        String domainid = "DIljHYOpEoinRW2L5Hz";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        String id ="__l9d9fF3Hjz10C6SY3P0";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
//        params.add("application", "HdPeBqYwJyFyjHkhZu3");
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/applicationid/"+applicaion+"/workflow/flowstatert?id="+id);
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 流程节点耗时
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetFlowAndNodeTimeConsuming() throws Exception{
        String domainid = "uumsxrgm1KEEqSZIoHs";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/applicationid/"+applicaion+"/workflow" +
                        "/flowAndNodeTimeConsuming?daterange=thisyear&showmode=all");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 流程耗时占比
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetFlowTimeConsumingAccounting() throws Exception{
        String domainid = "uumsxrgm1KEEqSZIoHs";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/applicationid/"+applicaion+"/workflow" +
                        "/flowTimeConsumingAccounting?daterange=thisyear&showmode=all");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 流程实例占比
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetFlowAccounting() throws Exception{
        String domainid = "uumsxrgm1KEEqSZIoHs";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/applicationid/"+applicaion+"/workflow" +
                        "/flowAccounting?daterange=thisyear&showmode=all");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 流程耗时排序
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetDoAnalyzerActorTimeConsumingTopX() throws Exception{
        String domainid = "3CffNlgt9B9StIjIUPB";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/applicationid/"+applicaion+"/workflow" +
                        "/doAnalyzerActorTimeConsumingTopX?daterange=thisyear&showmode=all");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }



    /**
     * 获取可干预的节点
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetOtherNodeList() throws Exception{
        String domainid = "3CffNlgt9B9StIjIUPB";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/applicationid/"+applicaion+"/workflow" +
                        "/intervention/othernodes?id="+docid);
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * 获取可干预节点历史审批人
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testGetHisApprovers() throws Exception{
        String domainid = "3CffNlgt9B9StIjIUPB";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
        String nodeid = "1576034974731";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/applicationid/"+applicaion+"/workflow" +
                        "/intervention/approvers?id="+docid+"&nodeid="+ nodeid);
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }


    /**
     * 获取可干预节点的审批人
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testDoSelectByFlow() throws Exception{
        String domainid = "3CffNlgt9B9StIjIUPB";
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        String docid = "__04wWZV9n0CXFXdr7aIG";
        String flowid = "__qy2QvZYl8cSTsoJjS2c";
        String nodeid = "1576034974731";
        String roleid ="__gTdf962GOewSbT1n9K3";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/documents/"+docid+"/workflows/" +flowid+
                        "/selectApprovers?type=2&nodeId="+nodeid+"&selectId="+roleid+
                        "&pageNum=1&pageSize=10&applicationId"+applicaion);
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }


    /**
     * 获取可干预节点的审批人
     *
     * @return
     * @throws Exception
     */
    @Test
    public void testDoFlow() throws Exception{
        String applicaion = "sOZu9kthmxyP8qQfq0e";
        String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
        String nodeid = "1576034960540";
        String content ="{submit:[{nodeid: \"1576034960540\", isToPerson: true, userids: \"M88FvL0rnPRvkCTzLkF\"}]}";
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain/applicationid/"+applicaion+"/workflow/"+
                        "/intervention/flowstatert/doflow?id="+docid+"&nextnodeid="+nodeid
        );
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}
