package cn.myapps.authtime.fieldextents.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.fieldextends.model.FieldExtendsVO;
import cn.myapps.authtime.fieldextends.service.FieldExtendsProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.ProcessFactory;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class FieldextendAuthtimeControllerTest extends AbstractControllerTests {

    Cookie cookie;
    String domainid = "3CffNlgt9B9StIjIUPB";
    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    @Test
    public void testGetFieldextends() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/fieldextends");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testUpdateFieldextend() throws Exception {
        String content = "{\n" +
                "\n" +
                "  \"label\": \"12223\",\n" +
                "\n" +
                " \"respectiveField\": \"field2\",\n" +
                " \"sortNumber\": \"1\",\n" +
                "\n" +
                " \"type\": \"string\",\n" +
                "\n" +
                "\"enabel\": \"true\",\n" +
                "\n" +
                "\"forTable\": \"tableUser\"\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain/"+domainid+"/fieldextend");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
        FieldExtendsVO fieldExtendsVO = fieldExtendsProcess.qeuryFieldByLabelAndDomain("12223", domainid, "tableUser", "All");

        String id = fieldExtendsVO.getFid();
        String content1 = "{\n" +
                "\n" +
                "  \"label\": \"1222\",\n" +
                "\n" +
                " \"respectiveField\": \"field2\",\n" +
                " \"sortNumber\": \"1\",\n" +
                "\n" +
                " \"type\": \"string\",\n" +
                "\n" +
                "\"enabel\": \"true\",\n" +
                "\n" +
                "\"forTable\": \"tableUser\"\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder1 = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/fieldextend/"+id);
        requestBuilder1.cookie(cookie);
        requestBuilder1.content(content1);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);

        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testAddAndDeleteFieldextends() throws Exception {

        String content = "{\n" +
                "\t\"enabel\": false,\n" +
                "\t\"forTable\": \"tableUser\",\n" +
                "\t\"label\": \"123\",\n" +
                "\t\"respectiveField\": \"field2\",\n" +
                "\t\"sortNumber\": 1,\n" +
                "\t\"type\": \"string\"\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain/"+domainid+"/fieldextend");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
        FieldExtendsVO fieldExtendsVO = fieldExtendsProcess.qeuryFieldByLabelAndDomain("123", domainid, "tableUser", "All");

        String id = fieldExtendsVO.getFid();

        requestBuilder = buildDeleteRequest(
                "/api/authtime/domain/"+domainid+"/fieldextend");
        String content2 = fieldExtendsVO.getName()+"-"+id+"-"+fieldExtendsVO.getForTable();
        String content3 = "[\""+content2+"\"]";
        requestBuilder.cookie(cookie);
        requestBuilder.content(content3);

        resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

}
