package cn.myapps.authtime.domain.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.run.RuntimeWithConsulApp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collection;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class DomainProcessBeanTest {

//	@Test
//	public void test() {
//		fail("Not yet implemented");
//	}
	
	@Test
	public void testDoQuery() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
	    ParamsTable	params = new ParamsTable();
	    //params.setParameter("application", "2CqnTkYeIBIDxlaro7f");
	   // params.setParameter("t_users.id", "eUIracwRixp9Kk4djvW");
//	    DataPackage<DomainVO> vo =dProcess.doQuery(params);
//	    System.out.println("testDoQuery:"+vo.getDatas().size());
	}
	
	@Test
	public void testDoSimpleQuery() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
	    ParamsTable	params = new ParamsTable();
	    //params.setParameter("t_name", "��Ȩ��Ϣ");
	    Collection<DomainVO> vo = dProcess.doSimpleQuery(null);
	    //System.out.println("testDoSimpleQuery"+vo.size());
	}

	@Test
	public void testGetDomainByName() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		DomainVO domain = dProcess.getDomainByName("测试");
		Assert.assertTrue(domain != null);
	}

	@Test//TODO:和getDomainByName有什么区别？
	public void testGetDomainByDomainName() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		DomainVO domain = dProcess.getDomainByDomainName("测试");
		Assert.assertTrue(domain != null);
	}

	@Test
	public void testQueryDomainsByName() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		DataPackage<DomainVO> datas = dProcess.queryDomainsByName("测试", 1, 10);
		Assert.assertTrue(datas != null);
	}

	@Test
	public void testGetAllDomain() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		Collection<DomainVO>  domains = dProcess.getAllDomain();
		Assert.assertTrue(domains.size() > 0);
	}

	@Test
	public void testGetDomainByStatus() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		Collection<DomainVO>  domains = dProcess.getDomainByStatus(1);
		Assert.assertTrue(domains.size() > 0);
	}

	@Test
	public void testQueryDomainsByStatus() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		Collection<DomainVO> domains =dProcess.queryDomainsByStatus(1);
		Assert.assertTrue(domains.size() > 0);
	}

	@Test
	public void testGetDomainEmailConfig() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		//TODO:和view方法有什么区别？？
		DomainVO domain = dProcess.getDomainEmailConfig("3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(domain != null);
	}

	@Test
	public void testExcelExportFromDomain() throws FileNotFoundException, Exception {
		DomainProcess dProcess = new DomainProcessBean();
		String filePath = "D:/testExcelExportFromDomain.xls";
		FileOutputStream fos = new FileOutputStream(new File(filePath));
		dProcess.excelExportFromDomain(fos, "DIljHYOpEoinRW2L5Hz");
		Assert.assertTrue(new File(filePath).exists());
		Assert.assertTrue(new File(filePath).length()>0);
	}

	@Test
	public void testExcelImportToDomain() throws Exception {
		DomainProcess dProcess = new DomainProcessBean();
		DomainVO domain = dProcess.getDomainByName("测试");;
		String filePath = "D:/testExcelExportFromDomain.xls";
		dProcess.excelImportToDomain(domain, new File(filePath));
	}

}
