package cn.myapps.authtime.domain.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class DomainAuthtimeControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }


    @Test
    public void doList() throws Exception {
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        params.add("username","");
        params.add("currpage","1");
        params.add("pagelines","10");
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domains");
        requestBuilder.cookie(cookie);
        requestBuilder.params(params);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));


    }

    @Test
    public void getDomain() throws  Exception{
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DomainProcess domainProcess =AuthTimeServiceManager.domainRuntimeService();
        String content = "{\n" +
                "   \"name\": \"ekko1\",\n" +
                "\n" +
                "   \"systemName\": \"ekko1\",\n" +
                "\n" +
                "   \"smsMemberCode\": \"sam_hr\",\n" +
                "\n" +
                "   \"smsMemberPwd\": \"123456\",\n" +
                "\n" +
                "   \"description\": \"description\",\n" +
                "\n" +
                "   \"status\":0, \n" +
                "\n" +
                "   \"skinType\":\"h5\", \n" +
                "\n" +
                "   \"logoUrl\":\"\" \n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain");
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isCreated());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        DomainVO vo = domainProcess.getDomainByDomainName("ekko1");
        String id = vo.getId();
        //        params.add("username","");
//        params.add("currpage","1");
//        params.add("pagelines","10");
        MockHttpServletRequestBuilder requestBuilder1 = buildGetRequest(
                "/api/authtime/domain/"+id);
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);
        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));

        DepartmentVO dvo = departmentProcess.getRootDepartmentByDomainId(vo.getId());
        departmentProcess.doRemove(dvo.getId());
        domainProcess.doRemove(vo.getId());
    }

    @Test
    public void doSMSTest() throws  Exception {
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DomainProcess domainProcess =AuthTimeServiceManager.domainRuntimeService();
        String content = "{\n" +
                "   \"name\": \"ekko1\",\n" +
                "\n" +
                "   \"systemName\": \"ekko1\",\n" +
                "\n" +
                "   \"smsMemberCode\": \"sam_hr\",\n" +
                "\n" +
                "   \"smsMemberPwd\": \"123456\",\n" +
                "\n" +
                "   \"description\": \"description\",\n" +
                "\n" +
                "   \"status\":0, \n" +
                "\n" +
                "   \"skinType\":\"h5\", \n" +
                "\n" +
                "   \"logoUrl\":\"\" \n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain");
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isCreated());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        DomainVO vo = domainProcess.getDomainByDomainName("ekko1");

        String telephone = "17677617017";
        //        params.add("username","");
//        params.add("currpage","1");
//        params.add("pagelines","10");
        MockHttpServletRequestBuilder requestBuilder1 = buildGetRequest(
                "/api/authtime/domain/"+vo.getId()+"/sms/"+telephone);
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);
        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));

        DepartmentVO dvo = departmentProcess.getRootDepartmentByDomainId(vo.getId());
        departmentProcess.doRemove(dvo.getId());
        domainProcess.doRemove(vo.getId());
    }

    @Test
    public void doCreateDomain() throws Exception{
        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DomainProcess domainProcess =AuthTimeServiceManager.domainRuntimeService();
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        String content = "{\n" +
                "   \"name\": \"ekko1\",\n" +
                "\n" +
                "   \"systemName\": \"ekko1\",\n" +
                "\n" +
                "   \"smsMemberCode\": \"sam_hr\",\n" +
                "\n" +
                "   \"smsMemberPwd\": \"123456\",\n" +
                "\n" +
                "   \"description\": \"description\",\n" +
                "\n" +
                "   \"status\":0, \n" +
                "\n" +
                "   \"skinType\":\"h5\", \n" +
                "\n" +
                "   \"logoUrl\":\"\" \n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain");
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isCreated());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        DomainVO vo = domainProcess.getDomainByDomainName("ekko1");
        DepartmentVO dvo = departmentProcess.getRootDepartmentByDomainId(vo.getId());
        departmentProcess.doRemove(dvo.getId());
        domainProcess.doRemove(vo.getId());

    }


    @Test
    public void doUpdateDomain() throws Exception {
        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DomainProcess domainProcess =AuthTimeServiceManager.domainRuntimeService();
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        String content = "{\n" +
                "   \"name\": \"ekko1\",\n" +
                "\n" +
                "   \"systemName\": \"ekko1\",\n" +
                "\n" +
                "   \"smsMemberCode\": \"sam_hr\",\n" +
                "\n" +
                "   \"smsMemberPwd\": \"123456\",\n" +
                "\n" +
                "   \"description\": \"description\",\n" +
                "\n" +
                "   \"status\":0, \n" +
                "\n" +
                "   \"skinType\":\"h5\", \n" +
                "\n" +
                "   \"logoUrl\":\"\" \n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain");
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isCreated());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        DomainVO vo = domainProcess.getDomainByDomainName("ekko1");
        String content1 = "{\n" +
                "\t\"id\":\""+vo.getId()+"\",\n" +
                "\n" +
                "   \"name\": \"ekko1\",\n" +
                "\n" +
                "   \"systemName\": \"ekko1\",\n" +
                "\n" +
                "   \"smsMemberCode\": \"sam_hr\",\n" +
                "\n" +
                "   \"smsMemberPwd\": \"123456\",\n" +
                "\n" +
                "   \"description\": \"description\",\n" +
                "\n" +
                "   \"status\":0, \n" +
                "\n" +
                "   \"skinType\":\"h5\", \n" +
                "\n" +
                "   \"logoUrl\":\"\" \n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder1 = buildPutRequest(
                "/api/authtime/domain/"+vo.getId());
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder1.content(content1);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);
        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));
        DepartmentVO dvo = departmentProcess.getRootDepartmentByDomainId(vo.getId());
        departmentProcess.doRemove(dvo.getId());
        domainProcess.doRemove(vo.getId());
    }

    @Test
    public void doDeleteDomain() throws Exception{
        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DomainProcess domainProcess =AuthTimeServiceManager.domainRuntimeService();
        MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
        String content = "{\n" +
                "   \"name\": \"ekko1\",\n" +
                "\n" +
                "   \"systemName\": \"ekko1\",\n" +
                "\n" +
                "   \"smsMemberCode\": \"sam_hr\",\n" +
                "\n" +
                "   \"smsMemberPwd\": \"123456\",\n" +
                "\n" +
                "   \"description\": \"description\",\n" +
                "\n" +
                "   \"status\":0, \n" +
                "\n" +
                "   \"skinType\":\"h5\", \n" +
                "\n" +
                "   \"logoUrl\":\"\" \n" +
                "\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain");
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isCreated());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        DomainVO vo = domainProcess.getDomainByDomainName("ekko1");
        DepartmentVO dvo = departmentProcess.getRootDepartmentByDomainId(vo.getId());
        departmentProcess.doRemove(dvo.getId());

        MockHttpServletRequestBuilder requestBuilder1 = buildDeleteRequest(
                "/api/authtime/domain/"+vo.getId());
//        requestBuilder.params(params);
        requestBuilder.cookie(cookie);
        ResultActions resultActions1 = mockMvc.perform(requestBuilder1);
        resultActions1.andExpect(status().isOk());
        resultActions1.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions1.andExpect(jsonPath("$.errcode").value(0));
        resultActions1.andExpect(jsonPath("$.errmsg").value("ok"));

    }

    @Test
    public void getIcons() throws Exception{
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/icons");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}