package cn.myapps.authtime.dingding.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class DingdingAuthtimeControllerTest  extends AbstractControllerTests {
    Cookie cookie;
    String domainid = "3CffNlgt9B9StIjIUPB";
    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
        cookie.setPath("/");
    }
    @Test
    public void testSaveDingdingConfig() throws Exception {
        String content = "{\n" +
                " \"dingdingProxyType\": \"EnterpriseDingding\",\n" +
                " \"dingdingCorpID\": \"ding7d81a69e4305994735c2f4657eb6378f\",\n" +
                " \"dingdingAppSecret\": \"loGKNk0p-cKPxmDepS7IKHzWfCCF9qkb12Pg23w4c1ri1oum3DxIUcrD_aHqni0p\",\n" +
                " \"dingdingAppKey\": \"ding6qcw92fyodv7u7xa\",\n" +
                " \"dingdingServerHost\": \"http://office.teemlink.com:65533/obpm9\"\t\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/dingding");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testGetDingdingConfig() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/dingding");
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        requestBuilder.cookie(cookie);
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testValidationExtranetAccessAddress() throws Exception {
        String appkey = "ding6qcw92fyodv7u7xa";
        String appsecret = "loGKNk0p-cKPxmDepS7IKHzWfCCF9qkb12Pg23w4c1ri1oum3DxIUcrD_aHqni0p";
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/dingding/appkey/"+appkey+"/appsecret/"+appsecret);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

//    @Test
//    public void testSynchFromDingding() throws Exception {
//        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
//                "/api/authtime/domain/"+domainid+"/synchfromdingding");
//        ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//        resultActions.andExpect(status().isOk());
//        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//        resultActions.andExpect(jsonPath("$.errcode").value(0));
//        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//    }
//
//    @Test
//    public void testSynch2Dingding() throws Exception {
//        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
//                "/api/authtime/domain/"+domainid+"/synch2dingding");
//        ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//        resultActions.andExpect(status().isOk());
//        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//        resultActions.andExpect(jsonPath("$.errcode").value(0));
//        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//    }

    @Test
    public void testGetDingdingUrl() throws Exception {
        String applicationid = "sOZu9kthmxyP8qQfq0e";
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/application/"+applicationid+"/getdingdingurl");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testUpdateDingdingAgentId() throws Exception {
        String applicationid = "sOZu9kthmxyP8qQfq0e";
        String agentId = "123";
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/application/"+applicationid+"/updatedingdingagentid?id="+agentId);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testUpdateDingdingAppSecret() throws Exception {
        String applicationid = "sOZu9kthmxyP8qQfq0e";
        String appSecret = "123";
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/application/"+applicationid+"/updatedingdingappsecret?appsecret="+appSecret);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testUpdateDingdingAppKey() throws Exception {
        String applicationid = "sOZu9kthmxyP8qQfq0e";
        String appkey = "123";
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/application/"+applicationid+"/updatedingdingappkey?appkey="+appkey);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}
