package cn.myapps.authtime.department.service;

import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.run.RuntimeWithConsulApp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest(classes=RuntimeWithConsulApp.class)
public class DepartmentProcessBeanTest {

//	@Test
//	public void test() {
//		fail("Not yet implemented");
//	}
	
	@Test
	public void testDoSimpleQuery() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		ParamsTable params = new ParamsTable();
		params.setParameter("t_domain.id", "3CffNlgt9B9StIjIUPB");
		//params.setParameter("t_restype", 1);
		params.setParameter("application", "");
		Collection<DepartmentVO> vo =departmentProcess.doQueryByDomainAndApplication("","");
		//System.out.println("testDoSimpleQuery"+vo.size());
	}
	
	@Test
	public void testDoQuery() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		ParamsTable params = new ParamsTable();
		//params.setParameter("t_domain.id", "3CffNlgt9B9StIjIUPB");
		params.setParameter("_orderby", "orderByNo;id");
		params.setParameter("t_domain.id", "3CffNlgt9B9StIjIUPB");
		DataPackage<DepartmentVO> vo =departmentProcess.doQueryByDoaminAndSuperiorAndName("","","","", null, null, 1,10);
		//System.out.println("testDoSimpleQuery"+vo.getDatas().size());
	}
	
	@Test
	public void testDoSimpleQueryParamsString() throws Exception {
//		DepartmentProcess departmentProcess = new DepartmentProcessBean();
//		Collection<DepartmentVO>  vo =departmentProcess.doSimpleQuery(null, "HdPeBqYwJy");
//		System.out.println("testDoSimpleQueryParamsString:"+vo.size());
	}
	
	@Test
	public void testDoQueryByHQL() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
//		 StringBuffer fooHql = new StringBuffer();
//		 fooHql.append("FROM ").append(DepartmentVO.class.getName()).append(" vo ")
//		 	   .append(" where ").append(" vo.lanxinDeptId = :wxDeptId ")
//		 	   .append(" and ").append(" vo.domain.id = :domainId ");
		Map<String,Object> sqlParameterMap = new HashMap<String,Object>();
//		 sqlParameterMap.put("wxDeptId", "");
		 sqlParameterMap.put("domainId", "2CqnTkYeIBIDxlaro7f");
//		 String hql = fooHql.toString();
//		String hql = "from "+DepartmentVO.class.getName()+" vo where vo.domain.id = :domainId order by vo.level asc";
//		 Collection<DepartmentVO> vo =departmentProcess.doQueryByHQL(hql, 1, Integer.MAX_VALUE, sqlParameterMap);
//		 System.out.println("testDoQueryByHQL"+vo.size());
	}
	
	@Test
	public void testDoQueryByDomainAndLanxinDept() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		 Collection<DepartmentVO> vo = departmentProcess.doQueryByDomainAndLanxinDept(0, "2CqnTkYeIBIDxlaro7f");
		 //System.out.println("testDoQueryByHQL"+vo.size());
	}

	@Test
	public void testDoQueryByDomainAndWeixinDept() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		 Collection<DepartmentVO> vo = departmentProcess.doQueryByDomainAndWeixinDept("11", "2CqnTkYeIBIDxlaro7f");
		 //System.out.println("testDoQueryByHQL"+vo.size());
	}
	
	@Test
	public void testDoQueryByDomainOrderByLevel() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		 Collection<DepartmentVO> vo = departmentProcess.doQueryByDomainOrderByLevel("2CqnTkYeIBIDxlaro7f");
		 //System.out.println("testDoQueryByHQL"+vo.size());
	}
	
//	@Test
//	public void testDoQueryByDomainAndLevel() throws Exception{
//		DepartmentProcess departmentProcess = new DepartmentProcessBean();
//		 Collection<DepartmentVO> vo = departmentProcess.doQueryByDomainAndLevel("2CqnTkYeIBIDxlaro7f",2);
//		 System.out.println("testDoQueryByHQL"+vo.size());
//	}
	
	
	
	@Test
	public void testDoQueryByDomainOrderLevelDescOrderByNo() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		 Collection<DepartmentVO> vo = departmentProcess.doQueryByDomainOrderLevelDescOrderByNo("2CqnTkYeIBIDxlaro7f");
		 //System.out.println("testDoQueryByHQL"+vo.size());
	}
	
	@Test
	public void testDoQueryByDomainLikeName() throws Exception{
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> vo = departmentProcess.doQueryByDomainLikeName("3CffNlgt9B9StIjIUPB", "��");
		//System.out.println("testDoQueryByHQL"+vo.size());
	}

	@Test
	public void testQueryByUser() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.queryByUser("zPsp2hk7CEwtqeMCwtj");
		Assert.assertTrue(departments.size() > 0);
	}

	@Test
	public void testGetUnderDeptListString() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.getUnderDeptList("febFF7bdzJJ0HJyh3dc");
		Assert.assertTrue(departments.size() > 0);
	}

	@Test
	public void testGetUnderDeptListStringInt() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.getUnderDeptList("febFF7bdzJJ0HJyh3dc", 10);
		Assert.assertTrue(departments.size() > 0);
	}

//	@Test
//	public void testGetSuperiorDeptList() throws Exception {
//		DepartmentProcess departmentProcess = new DepartmentProcessBean();
//		Collection<DepartmentVO> departments = departmentProcess.getSuperiorDeptList("febFF7bdzJJ0HJyh3dc");
//		Assert.assertTrue(departments.size()>0);
//	}

	@Test
	public void testGetDepartmentByLevel() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.getDepartmentByLevel(0, "3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(departments.size()>0);

		Collection<DepartmentVO> departments2 = departmentProcess.getDepartmentByLevel(1, "3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(departments2.size() > 0);
	}

	@Test
	public void testGetRootDepartmentByDomainId() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		DepartmentVO department = departmentProcess.getRootDepartmentByDomainId("3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(department != null);
	}

	@Test
	public void testGetDepartmentByName() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.getDepartmentByName("测试",
				"3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(departments.size()>0);

	}

	@Test
	public void testGetDepartmentByNameAndLevel() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		DepartmentVO department = departmentProcess.getDepartmentByNameAndLevel("测试", 2,
				"3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(department != null);
	}

	@Test
	public void testGetChildrenCount() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		long count = departmentProcess.getChildrenCount("febFF7bdzJJ0HJyh3dc");
		Assert.assertTrue(count > 0);
	}

	@Test
	public void testQueryByDomain() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.queryByDomain("3CffNlgt9B9StIjIUPB");
		Assert.assertTrue(departments.size() > 0);
	}

//	@Test
//	public void testGetSuperiorDeptListExcludeCurrent() throws Exception {
//		DepartmentProcess departmentProcess = new DepartmentProcessBean();
//		Collection<DepartmentVO> departments = departmentProcess.getSuperiorDeptList("febFF7bdzJJ0HJyh3dc");
//		Assert.assertTrue(departments.size() > 0);
//	}

	@Test
	public void testGetUnderDeptListStringIntBoolean() throws Exception {
		DepartmentProcess departmentProcess = new DepartmentProcessBean();
		Collection<DepartmentVO> departments = departmentProcess.getUnderDeptList("febFF7bdzJJ0HJyh3dc", 2, true);
		Assert.assertTrue(departments.size() > 0);
	}

}
