package cn.myapps.authtime.department.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class DepartmentAuthtimeControllerTest extends AbstractControllerTests {
    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();

        SuperUserVO user = sprocess.login("admin", "teemlink");

        WebUser webUser = null;
        String token = null;
        webUser = new WebUser(user);
        AuthTimeServiceManager.setAdminUser(webUser, session);

        token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
    }

    @Test
    public void testGetSubDepartments() throws Exception {
        String domainid = "3CffNlgt9B9StIjIUPB";
        String departmentid = "QNj0mrWmExFRsfwOYr5";
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/department/"+departmentid+"/subdepartments");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testGetDepartment() throws Exception {
        String id = "QNj0mrWmExFRsfwOYr5";
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/department/"+id);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testDoCreateAndUpdateAndDeleteDepartment() throws Exception {
        String domainid = "3CffNlgt9B9StIjIUPB";
        String content = "{\n" +
                "\n" +
                " \"sortId\": \"156930872825700000\",\n" +
                "\n" +
                "\"indexCode\": \"5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s_3nvysoo7nWKoxp0FShm___YDoiFDn8a3nGWWoH4xu\",\n" +
                "\n" +
                "\"weixinDeptId\": \"44\",\n" +
                "\n" +
                "\"lanxinDeptId\": \"\",\n" +
                "\n" +
                "\"name\": \"测试微信12\",\n" +
                "\n" +
                "\"code\": \"代码\",\n" +
                "\n" +
                "\"orderByNo\": 1,\n" +
                "\n" +
                " \"valid\": 1,\n" +
                "     \n" +
                " \"field1\": \"部门新建字段\",\n" +
                "     \n" +
                " \"_superiorid\": \"Z42xU8LmniRouZ93E7s\"\n" +
                "}";
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/authtime/domain/"+domainid+"/department");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("保存成功"));

        DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        DepartmentVO departmentVO = departmentProcess.getDepartmentByNameAndLevel("测试微信12",0,domainid);

        //update
        String content2 = "{\n" +
                "\"id\": \""+departmentVO.getId()+"\",\n" +
                "\n" +
                " \"sortId\": \"156930872825700000\",\n" +
                "\n" +
                "\"indexCode\": \"5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s_3nvysoo7nWKoxp0FShm___YDoiFDn8a3nGWWoH4xu\",\n" +
                "\n" +
                "\"weixinDeptId\": \"44\",\n" +
                "\n" +
                "\"lanxinDeptId\": \"\",\n" +
                "\n" +
                "\"name\": \"测试微信2221\",\n" +
                "\n" +
                "\"code\": \"代码\",\n" +
                "\n" +
                "\"orderByNo\": 1,\n" +
                "\n" +
                " \"valid\": 1,\n" +
                "     \n" +
                " \"field1\": \"部门新建字段\",\n" +
                "     \n" +
                " \"_superiorid\": \"Z42xU8LmniRouZ93E7s\"\n" +
                "}";
        requestBuilder = buildPutRequest(
                "/api/authtime/domain/"+domainid+"/department/111");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content2);
        resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("保存成功"));

        //delete
        String content3 = "[\n" +
                "    \""+departmentVO.getId()+"\"\n" +
                "]";
        requestBuilder = buildDeleteRequest(
                "/api/authtime/department");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content3);
        resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testdoList() throws Exception {
        String domainid = "3CffNlgt9B9StIjIUPB";
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/authtime/domain/"+domainid+"/departments");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}
