package cn.myapps;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.NoticeApi;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.runtime.notice.Notice;

@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.DEFINED_PORT, classes = RuntimeWithConsulApp.class)
@Import({FeignAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class})
@EnableFeignClients
@EnableAutoConfiguration
public class TestFeign {

//    @FeignClient(value = "obpm-message", url = "127.0.0.1:8084")
//    public interface TestApi extends NoticeApi {
//    }
//    @Autowired
//    private NoticeApi2 testApi;
//
//    @Test
//    public void test() {
//    	Notice notice = new Notice();
//    	notice.setId("123456");
//    	testApi.createNotice(notice);
//    }
    
    @Test
    public void test2() {
    	Notice notice = new Notice();
    	notice.setId("1111111");
    	NoticeApi noticeApi = SpringApplicationContextUtil.getBean(NoticeApi.class);
    	noticeApi.createNotice(notice);
    }

}  
