package cn.myapps.run;

import com.bcxin.runtime.apis.RuntimeConfig;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class })
@ComponentScan(basePackages = {
		"com.bcxin.event.repositories",
		"com.bcxin.runtime.apis",
		"com.bcxin.spring", "cn.myapps.conf", "cn.myapps.common.util",
		"cn.myapps.runtime.rest.security.service",
		"cn.myapps.util", "cn.myapps.base.web", "cn.myapps.runtime.common.utils",
		"cn.myapps.runtime.excutor.async",
		"cn.myapps.**.action", "cn.myapps.**.controller","com.teemlink.**.service",
		"com.teemlink.**.controller", "cn.myapps.**.service",
		"cn.myapps.**.action", "com.teemlink.km", "cn.myapps.common.exception", "cn.myapps.**.dao",
		"cn.myapps.designtime.report", "cn.myapps.runtime.workflow.analyzer", "com.jgqz",
		"cn.myapps.runtime.dynaform.document.ejb","cn.myapps.**.log.aspect",
		"cn.myapps.scheduler", "com.bcxin.event.repositories", "com.bcxin.spring",
"cn.myapps.runtime.macro"})
//开启Feign客户端
@Import({FeignAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, RuntimeConfig.class,
		com.bcxin.web.commons.SetupConfig.class})
@EnableFeignClients(basePackages = {"cn.myapps.conf","cn.myapps.runtime.common.feign.service"})
@EnableWebMvc
public class RuntimeWithConsulApp {
	public static void main(String[] args) {
		try {
			SpringApplication.run(RuntimeWithConsulApp.class, args);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
