package com.teemlink.email.util;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map.Entry;

public class FileUtil {

	
	/**
	 * 转存时文件复制
	 * @param newPath 转存到路径
	 * @param oldPath 原路径
	 */
	public static void copyFile(String newPath,String oldPath) throws Exception{
		InputStream inStream = null;
		FileOutputStream fs = null;
		try{
			int bytesum = 0;
			int byteread = 0;
			File oldfile = new File(oldPath); 
			if (oldfile.exists()) { //文件存在时 
				inStream = new FileInputStream(oldPath); //读入原文件 
				fs = new FileOutputStream(newPath); 
				byte[] buffer = new byte[1444]; 
				while ( (byteread = inStream.read(buffer)) != -1) { 
					bytesum += byteread; //字节数 文件大小
					//System.out.println(bytesum);
					fs.write(buffer, 0, byteread);
				}
			}
		}catch (Exception e) {
			//System.out.println("复制单个文件操作出错");
			e.printStackTrace();
			throw e;
		}finally {
			if(inStream != null){
				inStream.close();
			}
			if(fs != null){
				fs.close();
			}
		}
	}
	
	/**
	 * 拷贝模板
	 * @param des 目标目录路径
	 * @param src 源目录路径
	 * @throws Exception
	 */
	public  static  void  copyDir(  String  des,String  src)  throws  Exception {
		 File  srcFile = new  File(src);
		 File[]  srcFs = srcFile.listFiles();
		 File  desFile = new  File(des);
		 if(!desFile.exists()) {
			 desFile.mkdirs();
		 }
		 for  (File  srcFileItem  :  srcFs) {
			  //如果是文件，则拷贝文件
			 if(srcFileItem.isFile()) {
                 copyFile(des+srcFileItem.separator+srcFileItem.getName(),srcFileItem.getPath());
			 }
			 //如果是目录，则递归拷贝
			 else if(srcFileItem.isDirectory()) {
				 copyDir(des+srcFileItem.separator+srcFileItem.getName(),srcFileItem.getPath());
			 }
		 }
		 
		 
	}
	
	public static String FormetFileSize(long fileS) {//转换文件大小
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        if (fileS < 1024) {
            fileSizeString = df.format((double) fileS) + "B";
        } else if (fileS < 1048576) {
            fileSizeString = df.format((double) fileS / 1024) + "K";
        } else if (fileS < 1073741824) {
            fileSizeString = df.format((double) fileS / 1048576) + "M";
        } else {
            fileSizeString = df.format((double) fileS / 1073741824) + "G";
        }
        return fileSizeString;
    }

	/**
	 * @param args
	 */
	public static void main(String[] args) {

	}

}
