package com.teemlink.email.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import cn.myapps.auth.model.Domain;
import cn.myapps.email.model.WebUser;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.EmailService;
import com.teemlink.email.runtime.mail.AuthProfile;
import com.teemlink.email.runtime.mail.ConnectionMetaHandler;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.runtime.mail.ProtocolFactory;


/**
 * 
 * @author Tom
 *
 */
public class EmailProcessUtil {
	
	//private static final Logger log = LoggerFactory.getLogger(EmailProcessUtil.class);
	public static Map<String,List<String>> userFolderMap = new HashMap<>();

	/**
	 * 
	 * @param iProcessClass
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public static EmailService<?> createProcess(Class<?> iProcessClass, HttpServletRequest request,WebUser webUser) throws Exception {
//		HttpSession session = request.getSession();
		//WebUser webUser = AuthTimeServiceManager.getWebUser(request);

		//System.out.println("WebUser DomainId --------------->"+webUser.getDomainid());
		return createProcess(iProcessClass, webUser);
	}
	
	/**
	 * 
	 * @param iProcessClass
	 * @return
	 * @throws Exception
	 */
	public static EmailService<?> createProcess(Class<?> iProcessClass, WebUser webUser) throws Exception {
		//System.out.println("WebUser DomainId --------------->"+webUser.getDomainid());
		//DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
		Domain emailConfig =webUser.getDomain();
		if (!"true".equals(emailConfig.getIsUseClient())) {
			return null;
		}
		String fetchProtocol = emailConfig.getFetchProtocol();
		String cn = "";
		if("POP3".equalsIgnoreCase(fetchProtocol)){
			 cn = iProcessClass.getName() + "Pop3Bean";
		}else{
			 cn = iProcessClass.getName() + "ImapBean";
		}
		Class<?> protocolClass = Class.forName(cn);
		try {
			Constructor<?> constructor = protocolClass.getConstructor(ProtocolFactory.class);
			if (constructor != null) {
				//通过domain获取相应的profile

				ConnectionProfile profile = Domain2ProfileUtil.toProfile(emailConfig);
				
				EmailUser user = webUser.getEmailUser();
				ConnectionMetaHandler handler = webUser.getConnectionMetaHandler();
				AuthProfile auth = new AuthProfile();
				auth.setUserName(user.getAccount());
				auth.setPassword(user.getPassword());
				ProtocolFactory factory = new ProtocolFactory(profile, auth, handler,emailConfig.getFunctionDomain());
				return (EmailService<?>) constructor.newInstance(factory);
			}
		} catch (Exception e) {
			//log.debug("{}", e.getMessage());
			e.printStackTrace();
		}
		return (EmailService<?>) protocolClass.newInstance();
		
	}
	
}
