package com.teemlink.email.folder.service;

import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import com.teemlink.email.email.base.EmailValueObject;
import cn.myapps.common.util.StringUtil;
import com.sun.mail.pop3.POP3Folder;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.mail.Pop3ProtocolImpl;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.mail.Folder;
import java.util.*;

public class EmailFolderProcessPop3Bean extends AbstractEmailServiceImpl<EmailFolder> implements
        EmailFolderProcess {
    /**
     *
     */
    private static final long serialVersionUID = 6319523364694651021L;
    private transient ProtocolFactory protocolFactory;

    private static final Logger LOG = LoggerFactory.getLogger(EmailFolderProcessPop3Bean.class);

    public EmailFolderProcessPop3Bean() {
    }

    public EmailFolderProcessPop3Bean(ProtocolFactory protocolFactory) throws Exception {
        this.protocolFactory = protocolFactory;
    }

    protected IEamilDAO<EmailFolder> getDAO() throws Exception {
        return null;
    }

    public void doCreateEmailFolderByName(String folderName, String ownerId) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
        protocol.createFolder();
        protocol.updateFolders();
    }

    private boolean createEmailFolderByName(Pop3ProtocolImpl protocol) throws Exception {
        if (getSystemEmailFolderByName(protocol.getFolderName()) == null) {
            protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
            protocol.createFolder();
            Thread.sleep(1000);
            return true;
        }
        return false;
    }

    public EmailFolder getEmailFolderById(String folderid) throws Exception {
        try {
            POP3Folder folder = (POP3Folder) protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.parseLong(folderid));
            if (folder != null) {
                return EmailFolder.valueOf(folder);
            }
        } catch (NumberFormatException e) {
            LOG.warn("{}", e.toString());
        }
        return null;
    }

    public EmailFolder getEmailFolderByOwnerId(String folderName, String ownerId) throws Exception {
        Map<Long, Folder> folders = null;
        if (Constants.SYSTEM_FOLDER_ID.equals(ownerId)) {
            folders = protocolFactory.getConnectionMetaHandler().getSystemFolders();
        } else {
            folders = protocolFactory.getConnectionMetaHandler().getOtherFolders();
        }
        if (folders != null) {
            Set<Map.Entry<Long, Folder>> entrys = folders.entrySet();
            for (Iterator<Map.Entry<Long, Folder>> it = entrys.iterator(); it.hasNext();) {
                Map.Entry<Long, Folder> entry = it.next();
                POP3Folder folder = (POP3Folder) entry.getValue();
                if (folder.getFullName().equals(folderName)) {
                    return EmailFolder.valueOf(folder);
                }
            }
        }
        return null;
    }

    public DataPackage<EmailFolder> getPersonalEmailFolders(EmailUser user, int page, int lines) throws Exception {
        Map<Long, Folder> personalFolders = protocolFactory.getConnectionMetaHandler().getOtherFolders();
        Collection<EmailFolder> result = new ArrayList<EmailFolder>();
        Set<Map.Entry<Long, Folder>> entrys = personalFolders.entrySet();
        for (Iterator<Map.Entry<Long, Folder>> it = entrys.iterator(); it.hasNext();) {
            Map.Entry<Long, Folder> entry = it.next();
            POP3Folder folder = (POP3Folder) entry.getValue();
            EmailFolder ef = EmailFolder.valueOf(folder);
            if (ef != null) {
                result.add(ef);
            }
        }
        DataPackage<EmailFolder> dp = new DataPackage<EmailFolder>();
        dp.datas = result;
        dp.setPageNo(1);
        dp.setLinesPerPage(Integer.MAX_VALUE);
        dp.setRowCount(result.size());
        return dp;
    }

    public Collection<EmailFolder> getSystemEmailFolders() throws Exception {
        Map<Long, Folder> systemFolders = protocolFactory.getConnectionMetaHandler().getSystemFolders();
        Collection<EmailFolder> result = new ArrayList<EmailFolder>();
        Set<Map.Entry<Long, Folder>> entrys = systemFolders.entrySet();
        for (Iterator<Map.Entry<Long, Folder>> it = entrys.iterator(); it.hasNext();) {
            Map.Entry<Long, Folder> entry = it.next();
            POP3Folder folder = (POP3Folder) entry.getValue();
            EmailFolder ef = EmailFolder.valueOf(folder);
            if (ef != null) {
                result.add(ef);
            }
        }
        return result;
    }

    public void initCreatDefaultMailFolder() throws Exception {
        Pop3ProtocolImpl protocol = null;
        boolean isUpdate = false;
        protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_DRAFTS);
        isUpdate = createEmailFolderByName(protocol);
        protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_JUNK);
        if (!isUpdate) {
            isUpdate = createEmailFolderByName(protocol);
        } else {
            createEmailFolderByName(protocol);
        }
        protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_SENT);
        if (!isUpdate) {
            isUpdate = createEmailFolderByName(protocol);
        } else {
            createEmailFolderByName(protocol);
        }
        protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_REMOVED);
        if (!isUpdate) {
            isUpdate = createEmailFolderByName(protocol);
        } else {
            createEmailFolderByName(protocol);
        }
        if (protocol != null && isUpdate) {
            protocol.updateFolders();
        }
    }

    public boolean emailFolderIsCreate(String folderName, String ownerid) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
        Folder folder = protocol.getFolder();
        if (folder == null || !folder.exists()) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        // ConnectionProfile profile = EmailConfig.getConnectionProfile();
        // AuthProfile auth = new AuthProfile();
        // ConnectionMetaHandler handler = null;
        // auth.setUserName("");
        // auth.setPassword("");
        // ProtocolFactory factory = new ProtocolFactory(profile, auth,
        // handler);
        // EmailFolderProcessImapBean bean = new
        // EmailFolderProcessImapBean(factory);
        // EmailFolder emailFolder =
        // bean.getEmailFolderByOwnerId(Constants.DEFAULT_FOLDER_INBOX,
        // Constants.SYSTEM_FOLDER_ID);
        // ////System.out.println(emailFolder);
        // Collection folders = bean.getSystemEmailFolders();
        // for (Iterator it = folders.iterator(); it.hasNext(); ) {
        // EmailFolder folder = (EmailFolder) it.next();
        // //System.out.println(folder);
        // }
    }

    public EmailFolder getSystemEmailFolderByName(String folderName) throws Exception {
        return getEmailFolderByOwnerId(folderName, Constants.SYSTEM_FOLDER_ID);
    }

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {
        EmailFolder folder = (EmailFolder) vo;
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folder.getName());
        protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
        protocol.createFolder();
        protocol.updateFolders();
    }

    @Override
    public void doUpdate(EmailValueObject vo) throws Exception {
        EmailFolder folder = (EmailFolder) vo;
        if (StringUtil.isBlank(folder.getId())) {
            throw new OBPMValidateException("{*[core.email.folder.create.error]*}");
        }
        POP3Folder oldFolder = (POP3Folder) protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.valueOf(folder.getId()));
        if (oldFolder == null) {
            throw new OBPMValidateException("{*[core.email.folder.create.error]*}");
        }
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(oldFolder.getName());
        protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
        protocol.renameTo(folder.getName());
        protocol.updateFolders();
    }

    public void doRemoveEmailFolder(EmailFolder folder, EmailUser user) throws Exception {
        if (StringUtil.isBlank(folder.getId())) {
            throw new OBPMValidateException("{*[core.email.folder.delete.error]*}");
        }
        POP3Folder oldFolder = (POP3Folder) protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.valueOf(folder.getId()));
        if (oldFolder == null) {
            throw new OBPMValidateException("{*[core.email.folder.delete.error]*}");
        }
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(oldFolder.getName());
        protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
        if (protocol.getTotalMessageCount() > 0) {
            throw new OBPMValidateException("{*[core.email.folder.deleted]*}");
        }
        protocol.deleteFolder(true);
    }

    public int getPersonalEmailFolderCount(String ownerid) throws Exception {
        Map<Long, Folder>  folders = protocolFactory.getConnectionMetaHandler().getOtherFolders();
        if (folders != null) {
            return folders.size();
        }
        return 0;
    }
}
