package com.teemlink.email.folder.model;

import java.util.Date;

import javax.mail.Folder;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import com.teemlink.email.util.Constants;

import com.teemlink.email.email.base.EmailValueObject;

@Entity
@Table(name="T_EMAIL_FOLDER")
public class EmailFolder extends EmailValueObject {

	private static final long serialVersionUID = -7026205939786472851L;
	@Id
	@Column(name = "ID")
	private String id;
	@Column(name = "OWNERID")
	private String ownerId;
	@Column(name = "NAME")
	private String name;
	@Column(name = "DISPLAYNAME")
	private String displayName;
	@Column(name = "CREATDATE")
	private Date createDate;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the ownerId
	 */
	public String getOwnerId() {
		return ownerId;
	}

	/**
	 * @param ownerId the ownerId to set
	 */
	public void setOwnerId(String ownerId) {
		this.ownerId = ownerId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the createDate
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * @param createDate the createDate to set
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the displayName to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	
	@Override
	public String toString() {
		return "[id=" + id + ", name=" + name +"]";
	}
	
	public static EmailFolder valueOf(Folder folder) {
		EmailFolder emailFolder = null;
		if (folder != null) {
			try {
				if(folder instanceof IMAPFolder){
					IMAPFolder _folder = (IMAPFolder)folder;
					emailFolder = new EmailFolder();
					emailFolder.setId(String.valueOf(_folder.getName().hashCode() * _folder.getFullName().hashCode()));
					emailFolder.setName(_folder.getFullName());
					emailFolder.setDisplayName(Constants.getFolderDisplay(emailFolder.getName()));
				}else if(folder instanceof POP3Folder){
					POP3Folder _folder = (POP3Folder)folder;
					emailFolder = new EmailFolder();
					//TODO 寻求解决方案
					long hashCode = _folder.getName().hashCode() * _folder.getFullName().hashCode();
					emailFolder.setId(String.valueOf(hashCode));
					emailFolder.setName(folder.getFullName());
					emailFolder.setDisplayName(Constants.getFolderDisplay(emailFolder.getName()));
				}
				
			} catch (Exception e) {
			}
		}
		return emailFolder;
	}
	
}
