package com.teemlink.email.folder.dao;

import com.teemlink.email.folder.model.EmailFolder;

import com.teemlink.email.email.dao.IEamilDAO;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;

public interface EmailFolderDAO extends IEamilDAO<EmailFolder> {

	public EmailFolder queryMailFolderById(String folderid) throws Exception;
	
	public EmailFolder queryMailFolderByOwnerId(String folderName, String ownerId) throws Exception;
	
	/**
	 * 根据文件名称判断该文件是否已创建
	 * @param folderName
	 * @return
	 */
	public boolean judgeMailFolderIsCreate(String folderName, String ownerid) throws Exception;
	
	public int queryPersonalEmailFolderCount(String ownerid) throws Exception;
	
	public DataPackage<EmailFolder> queryPersonalEmailFolders(String ownerid, ParamsTable params) throws Exception;
	
	public DataPackage<EmailFolder> queryPersonalEmailFolders(String ownerid, int page,int lines)
			throws Exception;
	
}
