package com.teemlink.email.email.service;

import com.teemlink.email.email.base.EmailValueObject;

import java.io.Serializable;
import java.util.Collection;

public interface EmailService<E> extends Serializable {
    /**
     * 创建数据文档对象
     *
     * @param object
     *            数据文档对象.
     * @throws Exception
     */
    public abstract void doCreate(EmailValueObject object) throws Exception;

    /**
     * 批量创建数据文档对象
     *
     * @param vos
     *            数据文档对象集合
     * @throws Exception
     */
    public abstract void doCreate(Collection<EmailValueObject> vos) throws Exception;

    /**
     * 移除数据文档对象
     *
     * @param pk
     *            数据文档对象ID标识.
     * @throws Exception
     */
    public abstract void doRemove(String pk) throws Exception;

    /**
     * 批量移除数据文档对象
     *
     * @param pks
     *            数据文档对象ID标识数组.
     * @throws Exception
     */
    public void doRemove(String[] pks) throws Exception;

    /**
     * 更新数据文档对象.
     *
     * @param object
     *            数据文档对象.
     * @throws Exception
     */
    public abstract void doUpdate(EmailValueObject object) throws Exception;


    /**
     * 根据数据文档对象的ID标识查找数据文档对象.
     *
     * @param pk
     *            数据文档对象ID标识.
     * @return 数据文档对象.
     * @throws Exception
     */
    public abstract EmailValueObject doView(String pk) throws Exception;

    /**
     * 移除数据文档对象
     *
     * @param vo
     *            数据文档对象.
     * @throws Exception
     */
    public void doRemove(EmailValueObject vo) throws Exception;

}
