package com.teemlink.email.email.service;

import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.dao.EmailBodyRepository;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.util.Constants;

import org.springframework.beans.factory.annotation.Autowired;

public class EmailBodyProcessBean extends AbstractEmailServiceImpl<EmailBody> implements
		EmailBodyProcess {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6863199658668569708L;

	@Autowired
	EmailBodyRepository emailBodyRepository;

//	protected IEamilDAO<EmailBody> getDAO() throws Exception {
//		return new HibernateEmailBodyDAO(EmailBody.class.getName());
//	}
	
	@Override
	public void doCreate(EmailValueObject vo) throws Exception {
		EmailBody body = (EmailBody) vo;
		checkAddress(body);
		emailBodyRepository.save(body);
		//super.doCreate(body);
	}
	
	private void checkAddress(EmailBody emailBody) {
		//if (EmailConfig.isInternalEmail()) {
			
		//}
		if (emailBody == null) {
			return;
		}
		emailBody.setFrom(Constants.emailAddress2Account(emailBody.getFrom()));
		emailBody.setBcc(changeAddress(emailBody.getBcc()));
		emailBody.setCc(changeAddress(emailBody.getCc()));
		emailBody.setTo(changeAddress(emailBody.getTo()));
	}
	
	private String changeAddress(String address) {
		if (address == null) {
			return null;
		}
		String[] addresss = address.split(";");
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < addresss.length; i++) {
			if (buffer.length() > 1) {
				buffer.append(";").append(Constants.emailAddress2Account(addresss[i]));
			} else {
				buffer.append(Constants.emailAddress2Account(addresss[i]));
			}
		}
		return buffer.toString();
	}

	@Override
	public void doUpdate(EmailValueObject vo) throws Exception {
		EmailBody body = (EmailBody) vo;
		checkAddress(body);
		emailBodyRepository.save(body);
	}

}
