package com.teemlink.email.email.dao;

import com.teemlink.email.email.model.EmailUser;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public interface EmailUserRepository extends JpaRepository<EmailUser,String>, IEamilDAO<EmailUser> {

    EmailUser findEmailUserById(String id);

    EmailUser findByAccountAndDomainid(String account, String domainid);

    EmailUser findByAccount(String account);

    EmailUser findByOwneridAndDomainid(String ownerid,String domainid);
}
