package com.teemlink.email.email.action;

import java.util.Date;

import javax.mail.AuthenticationFailedException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import cn.myapps.auth.model.Domain;
import cn.myapps.email.model.WebUser;
import com.teemlink.email.email.service.EmailUserProcessBean;
import com.teemlink.email.util.Domain2ProfileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.EmailProcess;
import com.teemlink.email.email.service.EmailUserProcess;
import com.teemlink.email.runtime.mail.AuthProfile;
import com.teemlink.email.runtime.mail.ConnectionMetaHandler;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.runtime.mail.Protocol;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.util.Constants;

import cn.myapps.common.exception.OBPMValidateException;


public class EmailUserHelper {

	private static final Logger LOG = LoggerFactory.getLogger(EmailUserHelper.class);


	/**
	 * 登录邮件系统
	 * 
	 * @param webUser
	 * @throws Exception
	 * @throws SecurityException
	 */
	public static void loginEmailSystem(WebUser webUser) throws Exception, SecurityException {
		try {

			EmailUserProcess emailUserProcess = new EmailUserProcessBean();
			EmailUser emailUser = emailUserProcess.getEmailUserByOwner(webUser.getId(), webUser.getDomainid());
			if (emailUser == null) {
				emailUser = new EmailUser();
				emailUser.setAccount(webUser.getLoginno());
				emailUser.setName(webUser.getName());
				emailUser.setCreateDate(new Date());
				emailUser.setDomainid(webUser.getDomainid());
				emailUser.setOwnerid(webUser.getId());
				emailUserProcess.doCreate(emailUser);
			}
			EmailUserHelper.loginEmailSystem(webUser, emailUser);
		} catch (Exception e) {
			LOG.error("#########邮件系统登录失败！<Login failed mail system!>#########");
			if (webUser != null) {
				webUser.setEmailUser(null);
			}
			throw new OBPMValidateException("Login failed mail system");
		}
	}

	/**
	 * 登录邮件系统
	 * 
	 * @param webUser
	 * @throws Exception
	 * @throws SecurityException
	 */
	public static void loginEmailSystem(WebUser webUser, EmailUser emailUser) throws Exception, SecurityException {
		try {

			if (webUser == null) {
				throw new SecurityException("{*[page.timeout]*}");
			}
			// if (emailUser != null && !EmailConfig.isInternalEmail()) {
			// emailUser.setPassword(Security.decodeBASE64(emailUser.getPassword()));
			// }
			webUser.setEmailUser(emailUser);

		} catch (Exception e) {
			LOG.error("#########邮件系统登录失败！<Login failed mail system!>#########");
			if (webUser != null) {
				webUser.setEmailUser(null);
			}
			throw new OBPMValidateException("Login failed mail system");
		}
	}

	public static void initConnectionHandler(WebUser webUser,HttpServletRequest request) throws Exception {
		if (webUser == null || webUser.getEmailUser() == null) {
			throw new SecurityException("{*[page.timeout]*}");
		}
		/*
		 * if (EmailConfig.isInternalEmail()) { throw new
		 * Exception("{*[core.email.internal.error]*}"); }
		 */
		AuthProfile authProfile = new AuthProfile();
		authProfile.setUserName(webUser.getEmailUser().getAccount());
		authProfile.setPassword(webUser.getEmailUser().getPassword());
		ConnectionMetaHandler handler = new ConnectionMetaHandler();
		// 通过domain获取profile
		//DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
		Domain emailConfig = webUser.getDomain();
		ConnectionProfile profile = Domain2ProfileUtil.toProfile(emailConfig);
		ProtocolFactory factory = new ProtocolFactory(profile, authProfile, handler,emailConfig.getFunctionDomain());
		// 通过domain获取constants信息
		if (emailConfig.getTrash() != null && !"".equals(emailConfig.getTrash())) {
			Constants.DEFAULT_FOLDER_JUNK = emailConfig.getTrash();
		}
		if (emailConfig.getSender() != null && !"".equals(emailConfig.getSender())) {
			Constants.DEFAULT_FOLDER_SENT = emailConfig.getSender();
		}
		if (emailConfig.getRemoved() != null && !"".equals(emailConfig.getRemoved())) {
			Constants.DEFAULT_FOLDER_REMOVED = emailConfig.getRemoved();
		}
		if (emailConfig.getDraft() != null && !"".equals(emailConfig.getDraft())) {
			Constants.DEFAULT_FOLDER_DRAFTS = emailConfig.getDraft();
		}
		Protocol protocol = factory.getProtocol(Constants.DEFAULT_FOLDER_INBOX);
		handler = protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
		webUser.setConnectionMetaHandler(handler);

		// 但邮件文件夹不存在是，是否创建
		// EmailFolderProcess folderProcess = (EmailFolderProcess)
		// EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
		// folderProcess.initCreatDefaultMailFolder();
	}

	/**
	 * 退出邮件系统
	 * 
	 * @param session
	 */
//	public static void logoutEmailSystem(HttpSession session) {
//		WebUser webUser = WebUser.getWebuserFromCache(session);
//		if (webUser != null) {
//			webUser.disconnectOfEmail();
//		}
//	}

}
