package cn.myapps.conf;

import cn.myapps.common.util.PropertyUtil;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
//@EnableWebMvc
//@ComponentScan(basePackages = "cn.myapps.**.controller,cn.myapps.support.**.action,cn.myapps.support.**.controller,cn.myapps.designtime.**.action,cn.myapps.authtime.**.action,cn.myapps.runtime.**.action,com.teemlink.attendance.**.controller,com.teemlink.email.**.action,cn.myapps.message.**.controller,com.teemlink.pm.**.controller,com.teemlink.qm.**.controller", includeFilters = @Filter(classes = EnableWebMvc.class))
public class MyappsMvcConfig extends WebMvcConfigurerAdapter {


	public MyappsMvcConfig() {
//		new SpringApplicationContextUtil();
	}

//	@Autowired
//	public SpringApplicationContextUtil utils;

	@Bean
	public CommonsMultipartResolver multipartResolver() {
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		multipartResolver.setMaxUploadSize(-1);// 不限制上传文件大小
		return multipartResolver;
	}

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/**").addResourceLocations("classpath:/static/").addResourceLocations("/");
		String  uploadsFolderPath  =  PropertyUtil.getPath()+"/uploads/";
		System.out.println("==uploadsFolderPath:" + uploadsFolderPath );
		registry.addResourceHandler("/uploads/**").addResourceLocations("file:" + uploadsFolderPath );

		super.addResourceHandlers(registry);
	}
}
