import Login from "./components/Login/Login.vue";
import Homepage from "./components/Homepage/Homepage.vue";
import Inbox from "./components/Inbox/Inbox.vue";
import OpenInbox from "./components/OpenInbox/OpenInbox.vue";
import GarbageCan from "./components/GarbageCan/GarbageCan.vue";
import DeletedMessages from "./components/DeletedMessages/DeletedMessages.vue";
import Drafts from "./components/Drafts/Drafts.vue";

import Vue from "vue";
import Router from "vue-router";
import Main from "./views/Main.vue";
import Home from "./views/Home.vue";
//import printView from './components/print_view.vue'
// import Personal from './components/Personal.vue'

Vue.use(Router);

export default new Router({
  routes: [
    {
      path: "/",
      redirect: "/login",
    },
    {
      path: "/login",
      name: "login",
      component: Login,
    },
    {
      path: "/",
      component: Home,
      name: "",
      leaf: true, //只有一个节点
      iconCls: "el-icon-menu", //图标样式class
      children: [
        {
          path: "/homepage",
          component: Homepage,
          name: "首页",
        },
        {
          path: "/openInbox",
          component: OpenInbox,
          name: "进入收件箱",
        },
        {
          path: "/garbageCan",
          component: GarbageCan,
          name: "垃圾箱",
        },
        {
          path: "/deletedMessages",
          component: DeletedMessages,
          name: "已删除",
        },
        {
          path: "/inbox",
          component: Inbox,
          name: "收件箱",
        },
        {
          path: "/drafts",
          component: Drafts,
          name: "草稿箱",
        },
        {
          path: "/send",
          component: () => import("./components/Send/Send.vue"),
          name: "发件箱",
        },
        {
          path: "/email",
          component: () => import("./components/Email/Email.vue"),
          name: "写邮件",
        },
        {
          path: "/tip",
          component: () => import("./components/Tip/Tip.vue"),
          name: "Tip",
        },
      ],
    },
    {
      path: "/main",
      name: "main",
      component: Main,
    },
    {
      path: "/about",
      name: "about",
      component: () => import(/* webpackChunkName: "about" */ "./views/About.vue"),
    },
    // {
    //   path: '/test',
    //   name: 'test',
    //   component: () => import('./components/test.vue')
    // }
  ],
});
