package cn.myapps.listener;

import java.io.File;
import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.Environment;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.cache.EhcacheProvider;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeIndexCacheManager;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.init.InitSystem;
import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormTableProcess;
import cn.myapps.runtime.dynaform.form.ejb.FormTableProcessBean;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeService;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeServiceImpl;
import cn.myapps.util.RuntimeDaoManager;

public class ApplicationContextEventListener implements ApplicationListener<ApplicationContextEvent>{
	private static final Logger logger = LoggerFactory.getLogger(ApplicationContextEventListener.class);
	
    @Override
    public void onApplicationEvent(ApplicationContextEvent event) {
    	if(event instanceof ContextRefreshedEvent) {
        	logger.info("初始化Designer开始");
        	long start = System.currentTimeMillis();
            
    		try {
    			// 初始化应用真实路径
    			Environment evt = Environment.getInstance();
                
    			//设置当前环境的文件工作目录
    			//Environment.getInstance().getWorkspaceRootPath() = sce.getServletContext().getRealPath("/WEB-INF/workspace");
    			String workRootPath = evt.getWorkspaceRootPath();
    			File  newPath  =  new  File(workRootPath);
    			if(!newPath.exists()) {
    				logger.error(workRootPath+"目录不存在，请检查配置文件");
    			}
    			
				DesignTimeIndexCacheManager.getInstance().init(DesignTimeIndexCacheManager.MODE_DESIGNER);

    		} catch (Exception e) {
    			e.printStackTrace();
    		} finally {
    			try {
    				PersistenceUtils.closeSessionAndConnection();
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    		}
    		logger.info("初始化Designer结束，用时：" + (System.currentTimeMillis() - start) + " ms.");
    	}
    	else if (event instanceof ContextClosedEvent || event instanceof ContextStoppedEvent ){
    		logger.info("开始卸载资源");
    		try {
				EhcacheProvider cacheProvider = (EhcacheProvider) MyCacheManager.getProviderInstance();
				cacheProvider.destory();
				
			} catch (Exception e) {
				e.printStackTrace();
			}
    	}
    }
}
