package cn.myapps.designtime.workflow.definition.controller;

import java.util.*;

import cn.myapps.common.model.module.Module;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.workflow.element.Element;
import cn.myapps.runtime.workflow.element.ManualNode;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Api(tags = "流程设计模块")
@Component
@RequestMapping(path = "/api/designtime/applications", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class BillDefiController extends AbstractDesignTimeController {

    private BillDefiDesignTimeService billDefiDesignTimeService;

    private FormDesignTimeService formService;

    public BillDefiController() throws Exception {
        billDefiDesignTimeService = DesignTimeServiceManager.billDefiDesignTimeService();
        formService = DesignTimeServiceManager.formDesignTimeService();
    }


    /**
     * 新建流程
     *
     * @param applicationId 软件id
     * @param moduleId 模块id
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/{applicationId}/modules/{moduleId}/workflows")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "新建流程", notes = "新建流程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doNew(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content){
        BillDefiVO bl = new BillDefiVO();
        JSONObject json = JSONObject.fromObject(content);
        try {
             bl = (BillDefiVO)json2obj(json,BillDefiVO.class);
             Date lastmodify = new Date();
             bl.setLastmodify(lastmodify);
             bl.setId(Sequence.getDesignTimeSequence());
             bl.setParentId(moduleId);
             bl.setCheckout(true);
             bl.setCheckoutHandler(getUser().getId());
             doSaveValidate(bl);
             bl.setApplicationid(applicationId);
             billDefiDesignTimeService.doCreate(bl);
            JSONObject blJson = new JSONObject();
            blJson.put("id", bl.getId());
            return success("ok", blJson);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
//        return null;
    }

    /**
     * 获取流程列表
     *
     * @param moduleId 模块id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/{moduleId}/workflows")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取流程列表", notes = "获取流程列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageNo", value = "页码", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "linesPerPage", value = "页条数", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "name", value = "流程名称", required = true, paramType = "path", dataType = "string")})
    public Resource getFlows(@PathVariable String moduleId){
        ParamsTable params = getParams();
        String pageNo =  params.getParameterAsString("pageNo");
        String linesPerPage =  params.getParameterAsString("linesPerPage");
        String name =  params.getParameterAsString("name");
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        int line = (linesPerPage != null && linesPerPage.length() > 0) ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage<BillDefiVO> query = billDefiDesignTimeService.query(moduleId, name, page, line);
            JSONObject result = new JSONObject();
            JSONArray array = new JSONArray();
            for(BillDefiVO bl:query.getDatas()){
                JSONObject blJson = new JSONObject();
                blJson.put("id", bl.getId());
                blJson.put("name", bl.getName());
                array.add(blJson);
            }
            result.put("pageNo",query.pageNo);
            result.put("linesPerPage",query.linesPerPage);
            result.put("rowCount",query.rowCount);
            result.put("data",array);
            return success("ok", result);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取流程详情
     *
     * @param flowId 流程id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/workflows/{flowId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取流程详情", notes = "获取流程详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "flowId", value = "流程id", required = true, paramType = "path", dataType = "string")})
    public Resource getFlow(@PathVariable String flowId){
        try {
           BillDefiVO bl = billDefiDesignTimeService.findById(flowId);
           JSONObject result = new JSONObject();
           result.put("id",bl.getId());
           result.put("name",bl.getName());
           result.put("authorname",bl.getAuthorname());
           result.put("lastmodify",bl.getLastmodify());
           result.put("subject",bl.getSubject());
           result.put("flow",bl.getFlow());
           result.put("uri",bl.getUri());
           return success("ok", result);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 复制流程
     *
     * @param ids 流程id数组
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/modules/workflows/copy")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "复制流程", notes = "复制流程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource copyFlow(@RequestBody String[] ids){
        try {
            billDefiDesignTimeService.doCopyFlow(ids);
            return success("ok", "复制成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新流程
     *
     * @param flowId 流程id
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/modules/workflows/{flowId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新流程", notes = "更新流程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "flowId", value = "流程id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdate(@PathVariable String flowId, @RequestBody String content){
        
        JSONObject json = JSONObject.fromObject(content);
        try {
            BillDefiVO bl = (BillDefiVO)json2obj(json,BillDefiVO.class);
            Date lastmodify = new Date();
            bl.setId(flowId);
            bl.setLastmodify(lastmodify);
            bl.setCheckout(true);
            bl.setCheckoutHandler(getUser().getId());
            bl.setApplicationid((String) json.get("applicationId"));
            doSaveValidate(bl);
            billDefiDesignTimeService.doUpdate(bl);
            JSONObject blJson = new JSONObject();
            blJson.put("id", bl.getId());
            return success("ok", blJson);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除流程
     *
     * @param ids 流程id数组
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/modules/workflows")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除流程", notes = "删除流程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource delete(@RequestBody String[] ids){
        try {
            billDefiDesignTimeService.delete(ids);
            return success("ok", "删除流程");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 根据当前节点获取其他节点
     *
     * @param flowId 流程id
     * @param nodeId 流程id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/workflows/{flowId}/node/{nodeId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "根据当前节点获取其他节点", notes = "根据当前节点获取其他节点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "flowId", value = "流程id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "nodeId", value = "节点id", required = true, paramType = "path", dataType = "string")})
    public Resource getNodes(@PathVariable String flowId, @PathVariable String nodeId){
        ParamsTable params = getParams();
        String type = params.getParameterAsString("type");
        try {
            BillDefiVO bl = billDefiDesignTimeService.findById(flowId);
            Node node = bl.toFlowDiagram().getNodeByID(nodeId);
            Vector<Element> list = new Vector<>();
            if("0".equals(type)) {
                list = bl.toFlowDiagram().getAllBeforeNode(node, true);
            }
            JSONArray array = new JSONArray();
            for(Element element:list){
                ManualNode n = (ManualNode) element;
                JSONObject blJson = new JSONObject();
                blJson.put("id", n.id);
                blJson.put("name", n.name);
                array.add(blJson);
            }
            return success("ok", array);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 流程编辑器子流程获取父流程表单
     * @param applicationId
     * @param pageNo
     * @param formName
     * @param moduleName
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/{applicationId}/modules/workflows/flexGetForms")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "流程编辑器子流程获取父流程表单", notes = "流程编辑器子流程获取父流程表单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageNo", value = "页码", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "formName", value = "名称", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "moduleName", value = "模块名称", required = false, paramType = "query", dataType = "string")
    })
    public Resource flexGetFormsByParams(@PathVariable String applicationId,String pageNo,String formName,String moduleName){
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        JSONArray formArray = new JSONArray();
        JSONObject result = new JSONObject();
        try{
            DataPackage<Form> forms = formService.queryByApplicationIdAndModuleNameAndSubjectName(applicationId, moduleName, formName, page, 10);
            for (Iterator<Form> iterator = forms.datas.iterator(); iterator.hasNext();) {
                Form form = (Form) iterator.next();
                JSONObject formJson = new JSONObject();
                formJson.put("id", form.getId());
                formJson.put("formName", form.getName());
                formJson.put("moduleName", form.getModule().getName());
                if(form.getAllFields().size()==0){
                    form.inited();
                }
                List formFields = new ArrayList();
                Map nField = new HashMap();
                nField.put("name","--select--");
                nField.put("valuetype","");
                formFields.add(nField);
                for (Iterator<FormField> iter = form.getAllFields().iterator(); iter.hasNext();) {
                    FormField field = (FormField) iter.next();
                    Map formField = new HashMap();
                    formField.put("name",field.getName());
                    formField.put("valuetype",field.getFieldtype() == null ? "":field.getFieldtype());
                    formFields.add(formField);
                }
                formJson.put("formFields",formFields);
                formArray.add(formJson);
            }
            result.put("linesPerPage",forms.getLinesPerPage());
            result.put("pageCount",forms.getPageCount());
            result.put("pageNo",forms.getPageNo());
            result.put("rowCount",forms.getRowCount());
            result.put("data",formArray);
            return success("ok", result);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }

    /**
     * 流程编辑器获取所有流程
     * @param applicationId
     * @param pageNo
     * @param flowName
     * @param moduleName
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/{applicationId}/modules/workflows/flexGetBillDefiVOs")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "流程编辑器获取所有流程", notes = "流程编辑器获取所有流程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageNo", value = "页码", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "flowName", value = "名称", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "moduleName", value = "模块名称", required = false, paramType = "query", dataType = "string")
    })
    public Resource flexGetBillDefiVOs(@PathVariable String applicationId,String pageNo,String flowName,String moduleName){
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        JSONArray array = new JSONArray();
        JSONObject result = new JSONObject();
        try{
            DataPackage<BillDefiVO> billDefiVOs = billDefiDesignTimeService.queryByApplicationIdAndModuleNameAndSubjectName(applicationId, moduleName, flowName, page, 10);
            for (Iterator<BillDefiVO> iterator = billDefiVOs.datas.iterator(); iterator.hasNext();) {
                BillDefiVO billDefiVO = iterator.next();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", billDefiVO.getId());
                jsonObject.put("flowName", billDefiVO.getName());
                jsonObject.put("moduleName", billDefiVO.getParent().getName());
                array.add(jsonObject);
            }
            //获取模块名称集合
            ModuleDesignTimeService moduleService = DesignTimeServiceManager.moduleDesignTimeService();
            Collection<Module> moduleDatas = moduleService.list(applicationId,null);
            List modulearray = new ArrayList();
            modulearray.add("");
            if(moduleDatas.size()>0){
                for (Iterator<Module> ite = moduleDatas.iterator(); ite.hasNext();) {
                    Module module = ite.next();
                    modulearray.add(module.getName());
                }
            }

            result.put("linesPerPage",billDefiVOs.getLinesPerPage());
            result.put("pageCount",billDefiVOs.getPageCount());
            result.put("pageNo",billDefiVOs.getPageNo());
            result.put("rowCount",billDefiVOs.getRowCount());
            result.put("data",array);
            result.put("modulearray",modulearray);
            return success("ok", result);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }


    public void doSaveValidate(BillDefiVO bl) throws Exception{
        String subject = bl.getSubject();
        if(StringUtil.isBlank(subject)) {
            throw new OBPMValidateException("{*[workflow.subject.notempty]*}");
        }
        // 非法字符串检验
        String invalidChars = getInvalidChars(subject);
        if (!StringUtil.isBlank(invalidChars)) {
            throw new OBPMValidateException("{*[workflow.subject.exist.invalidchar]*}: "
                    + invalidChars);
        }
        validate(bl);
    }

    private String getInvalidChars(String name) {
        String[] p = { "﹉", "＃", "＠", "＆", "＊", "※", "§", "〃", "№", "〓", "○",
                "●", "△", "▲", "◎", "☆", "★", "◇", "◆", "■", "□", "▼", "▽",
                "㊣", "℅", "ˉ", "￣", "＿", "﹍", "﹊", "﹎", "﹋", "﹌", "﹟", "﹠",
                "﹡", "♀", "♂", "?", "⊙", "↑", "↓", "←", "→", "↖", "↗", "↙",
                "↘", "┄", "—", "︴", "﹏", "（", "）", "︵", "︶", "｛", "｝", "︷",
                "︸", "〔", "〕", "︹", "︺", "【", "】", "︻", "︼", "《", "》", "︽",
                "︾", "〈", "〉", "︿", "﹀", "「", "」", "﹁", "﹂", "『", "』", "﹃",
                "﹄", "﹙", "﹚", "﹛", "﹜", "﹝", "﹞", "\"", "〝", "〞", "ˋ",
                "ˊ", "≈", "≡", "≠", "＝", "≤", "≥", "＜", "＞", "≮", "≯", "∷",
                "±", "＋", "－", "×", "÷", "／", "∫", "∮", "∝", "∧", "∨", "∞",
                "∑", "∏", "∪", "∩", "∈", "∵", "∴", "⊥", "∥", "∠", "⌒", "⊙",
                "≌", "∽", "√", "≦", "≧", "≒", "≡", "﹢", "﹣", "﹤", "﹥", "﹦",
                "～", "∟", "⊿", "∥", "㏒", "㏑", "∣", "｜", "︱", "︳", "|", "／",
                "＼", "∕", "﹨", "¥", "€", "￥", "£", "®", "™", "©", "，", "、",
                "。", "．", "；", "：", "？", "！", "︰", "…", "‥", "′", "‵", "々",
                "～", "‖", "ˇ", "ˉ", "﹐", "﹑", "﹒", "·", "﹔", "﹕", "﹖", "﹗",
                "-", "&", "*", "#", "`", "~", "+", "=", "(", ")", "^", "%",
                "$", "@", ";", ",", ":", "'", "\\", "/", ".", ">", "<",
                "?", "!", "[", "]", "{", "}" };
        for (int i = 0; i < p.length; i++) {
            if (name != null && name.contains(p[i])) {
                return p[i];
            }
        }
        return "";
    }

    /**
     * 校验是否有重复的名称
     * @throws Exception
     */
    public void validate(BillDefiVO bl) throws Exception {

        List<BillDefiVO> list = (List<BillDefiVO>) billDefiDesignTimeService.list(bl.getParentId(),bl.getName());
        if(StringUtils.isBlank(bl.getId())) {
            //新建
            for (Iterator<BillDefiVO> iterator = list.iterator(); iterator.hasNext();) {
                BillDefiVO billDefiVO = iterator.next();
                if(billDefiVO.getName().equals(bl.getName())){
                    throw new OBPMValidateException("{*[workflow.subject.exist]*}");
                }
            }
        }else {
            //更新
            for (Iterator<BillDefiVO> iterator = list.iterator(); iterator.hasNext();) {
                BillDefiVO billDefiVO = iterator.next();
                if(billDefiVO.getId().equals(bl.getId())) {
                    continue;
                }
                if(billDefiVO.getName().equals(bl.getName())){
                    throw new OBPMValidateException("{*[workflow.subject.exist]*}");
                }
            }
        }
        for (Iterator<BillDefiVO> iterator = list.iterator(); iterator.hasNext();) {
            BillDefiVO billDefiVO = iterator.next();
            if(billDefiVO.getName().equals(bl.getName()) && !billDefiVO.getId().equals(bl.getId())){
                throw new OBPMValidateException("{*[workflow.subject.exist]*}");
            }
        }


    }

}
