package cn.myapps.designtime.wizard.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import cn.myapps.authtime.common.dao.IAuthTimeDAO;
import cn.myapps.authtime.common.service.AbstractAuthTimeServiceImpl;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityType;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.resource.ResourceType;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.view.constant.ViewConstant;
import cn.myapps.common.model.view.dto.ViewDirector;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.column.service.ColumnDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.wizard.util.WizardUtil;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.dao.DAOFactory;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.sequence.Sequence;

/**
 * WizardProcessBean class.
 * 
 * @author zhuxuehong, Sam
 * @since JDK1.4
 */

public class WizardProcessBean extends AbstractAuthTimeServiceImpl<WizardVO> implements WizardProcess {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1074889227713498941L;

	/**
	 * @SuppressWarnings getDefaultDAO得到的process不确定
	 */
	@SuppressWarnings("unchecked")
	protected IAuthTimeDAO<WizardVO> getDAO() throws Exception {
		return (IAuthTimeDAO<WizardVO>) DAOFactory.getDefaultDAO(WizardVO.class.getName());
	}

	private ModuleDesignTimeService moduleProcess;
	private FormDesignTimeService formService;

	private final static WizardUtil wizardUtil = new WizardUtil();

	private ViewDesignTimeService viewService;
	private BillDefiDesignTimeService billDefiService;
	private ResourceDesignTimeService resourceService;
	private ApplicationDesignTimeService applicationProcess;

	public WizardProcessBean() {
		try {
			setupProcesses();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void setupProcesses() throws Exception {
		moduleProcess = DesignTimeServiceManager.moduleDesignTimeService();
		formService = DesignTimeServiceManager.formDesignTimeService();
		viewService = DesignTimeServiceManager.viewDesignTimeService();
		billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
		resourceService = DesignTimeServiceManager.resourceDesignTimeService();
		applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
	}

	/**
	 * 当确认时，程序创建所有的表单，视图，菜单，流程
	 * 
	 * @param vo
	 *            向导VO
	 * @param user
	 *            当前在线用户
	 * @param applicationid
	 *            当前应用ID
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @throws Exception
	 */
	public void confirm(ValueObject vo, IUser user, String applicationid, String contextBasePath) throws Exception {
		WizardVO wizardvo = (WizardVO) vo;
		Module module = null;
		try {
			module = createModule(wizardvo, applicationid);

			Form mainForm = createMainForm(wizardvo, module, contextBasePath);
			Form subForm = null;
			if (wizardvo.getF_Type().equals("01")) {
				subForm = createSubForm(wizardvo, module, contextBasePath);
				AbstractView subView = createViewForSubForm(wizardvo,module, subForm, contextBasePath);
				wizardvo.setF_subForm_viewid(subView.getId());
				//updateSubForm(mainForm, subView, wizardvo, contextBasePath);
			}
			createWorkflow(wizardvo, module, mainForm, user, contextBasePath);

			ResourceVO topMenu = createResource(wizardvo, module);

			createView(wizardvo, module, topMenu, mainForm, contextBasePath);

		} catch (Exception e) {
			if(module != null){
				moduleProcess.delete(module.getId());
			}
			e.printStackTrace();
		}

	}

	/**
	 * 找回主表单，并设置子表单的关联
	 * 
	 * @param mainForm
	 *            主表单
	 * @param subView
	 *            给子表单用的视图
	 * @param wizardvo
	 *            向导VO
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @throws Exception
	 */
	private void updateSubForm(Form mainForm, AbstractView subView, WizardVO wizardvo, String contextBasePath) throws Exception {
		mainForm.setTemplatecontext(mainForm.getTemplatecontext()
				+ wizardUtil.getUpdatedTemplateContext(wizardvo, contextBasePath));
		formService.doUpdate(mainForm);
	}

	/**
	 * 创建流程
	 * 
	 * @param vo
	 *            向导VO
	 * @param Module
	 *            模块VO
	 * @param form
	 *            主表单
	 * @param user
	 *            当前在线用户
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @return 创建好的流程VO
	 * @throws Exception
	 */
	private BillDefiVO createWorkflow(WizardVO vo, Module Module, Form form, IUser user, String contextBasePath)
			throws Exception {
		BillDefiVO billDefiVO = new BillDefiVO();
		Date lastmodify = new Date();
		// wizardUtil = new WizardUtil();
		if (vo.getW_workflowid() == null || vo.getW_workflowid().trim().length() == 0) {

			billDefiVO.setApplicationid(vo.getApplicationid());
			billDefiVO.setAuthorname(user.getName());
			billDefiVO.setAuthorno(user.getLoginno());
			billDefiVO.setParentId(Module.getId());
			billDefiVO.setId(Sequence.getDesignTimeSequence());
			//System.out.println("W_content----------->"+wizardUtil.getW_content(contextBasePath, vo.getW_content()));
			billDefiVO.setFlow(wizardUtil.getW_content(contextBasePath, vo.getW_content()));
			billDefiVO.setLastmodify(lastmodify);
			billDefiVO.setSubject(vo.getW_name());

			billDefiService.doCreate(billDefiVO);
		} else {
			billDefiVO = (BillDefiVO) billDefiService.doView(vo.getW_workflowid());
			if (billDefiVO != null) {
				billDefiVO.setSubject(vo.getW_name());
				billDefiVO.setFlow(vo.getW_content());
				billDefiService.doUpdate(billDefiVO);
			}
		}

		// 如果选择了流程处理时则把form的流程处理(activity)和workflow联系起来
		ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
		Activity activity = new Activity();
		activity.setId(Sequence.getDesignTimeSequence());
		activity.setName("Submit_WorkFlow");
		activity.setApplicationid(vo.getApplicationid());
		if (billDefiVO != null){
			activity.setOnActionFlow(billDefiVO.getId());
		}
		activity.setParentForm(form.getId());
		activity.setType(ActivityType.WORKFLOW_PROCESS);
		activity.setParent(form);
		activity.setParentId(form.getId());
		activityService.save(activity);

		return billDefiVO;
	}

	/**
	 * 为子表单创建视图
	 * 
	 * @param vo
	 *            向导VO
	 * @param form
	 *            子表单
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @return 创建好的子表单视图
	 * @throws Exception
	 */
	private AbstractView createViewForSubForm(ValueObject vo,Module module, Form form, String contextBasePath) throws Exception {

		WizardVO wizardVO = (WizardVO) vo;
		Module Module = form.getModule();

		AbstractView view = ViewDirector.construct(ViewConstant.VIEW_TYPE_NORMAL);

		String formName = Module.getParent().getName() + "/" + Module.getName() + "/" + form.getName();
		String filterCode = "\"$formname = '" + formName + "\"";

		// 常规属性
		view.setId(Sequence.getDesignTimeSequence());
		view.setApplicationid(vo.getApplicationid());
		view.setName("SubFormView_".concat(wizardVO.getF_name_sub()));
		
		// 设置view的属性
		view.setOpenType(ViewConstant.OPEN_TYPE_POP);
		view.setEditMode(ViewConstant.EDIT_MODE_DESIGN);
		view.setFilterScript(filterCode);
		view.setModule(Module);
		view.setShowTotalRow(false);
		view.setPagination(true);
		view.setPageLines("15");
		view.setRelatedForm(form.getId());
		view.setParentId(module.getId());
		viewService.doCreate(view);

		// 建立与view相关的cloumn
		List<Column> subFormViewColumn = new ArrayList<Column>();

		// 设置column列
		// Column name = new Column();
		ColumnDesignTimeService columnService = DesignTimeServiceManager.columnDesignTimeService();
		String[] fields = null;
		if (wizardVO.getF_subForm_viewColumns().trim().length() > 0 && !wizardVO.getF_subForm_viewColumns().equals("")) {
			fields = wizardVO.getF_subForm_viewColumns().split(";");
		}
		if (fields != null) {// && fields.length > 0 && !"".equals(fields)
			for (int i = 0; i < fields.length; i++) {
				Column column = new Column();
				column.setId(Sequence.getDesignTimeSequence());
				column.setOrderno(i);
				column.setFormid(form.getId());
				column.setApplicationid(vo.getApplicationid());
				column.setParentView(view.getId());
				column.setFieldName(fields[i]);
				column.setName(fields[i]);
				column.setParent(view);
				column.setParentId(view.getId());
				columnService.save(column);
				subFormViewColumn.add(column);
			}
		}

		// 建立与view相关的activity
		ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
		Activity activity = null;
		if (wizardVO.getF_subForm_viewActivitys() != null) {

			String[] v_activity = wizardVO.getF_subForm_viewActivitys();

			if (v_activity != null && v_activity.length > 0) {
				for (int i = 0; i < v_activity.length; i++) {
					activity = new Activity();
					activity.setId(Sequence.getDesignTimeSequence());
					activity.setName((String) WizardVO._VIEWACLIST.get(v_activity[i]));
					activity.setType(Integer.parseInt(v_activity[i]));
					// activity.setOnActionView(view);
					activity.setParentView(view.getId());
					activity.setOrderno(i + 1);
					activity.setApplicationid(vo.getApplicationid());
					activity.setParent(view);
					activity.setParentId(view.getId());
					activityService.save(activity);
				}
			}
//			viewService.doUpdate(view);
		}

		return view;
	}

	/**
	 * 创建视图
	 * 
	 * @param vo
	 *            向导VO
	 * @param Module
	 *            模块VO
	 * @param resource
	 *            菜单VO
	 * @param form
	 *            主表单VO
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @throws Exception
	 */
	private void createView(WizardVO vo, Module Module, ResourceVO resource, Form form, String contextBasePath)
			throws Exception {

		String pendingFilterScript = "";
		String allFilterScript = "";
		String formName = Module.getParent().getName() + "/" + Module.getName() + "/" + form.getName();

		// 建立与view相关的searchForm
		Form searchForm = new Form();
		if (vo.getV_searchForm().length() > 0 && vo.getV_searchForm() != null) {
			searchForm.setApplicationid(vo.getApplicationid());
			searchForm.setId(Sequence.getDesignTimeSequence());
			searchForm.setModule(Module);
			searchForm.setSortId(Sequence.getTimeSequence());
			searchForm.setName(vo.getF_name() + "_Search");
			searchForm.setType(Form.FORM_TYPE_SEARCHFORM);
			searchForm.setTemplatecontext(wizardUtil.getV_searchForm(vo.getV_searchForm(), contextBasePath));
			searchForm.setParent(Module);
			searchForm.setParentId(Module.getId());
			formService.doCreate(searchForm);
			searchForm = (Form) formService.doView(searchForm.getId());
		}
		String[] v_type = vo.getV_type();
		if (v_type != null && v_type.length > 0) {
			for (int i = 0; i < v_type.length; i++) {
				if (v_type[i].equalsIgnoreCase(WizardVO.VIEWDISPLAY_PENDING)) {
					// 设置FORM的待办View
					vo.setPending(true);
					if (vo.getV_filter() != null && vo.getV_filter().length() > 0) {
						pendingFilterScript = wizardUtil.getV_filter(contextBasePath, vo, formName);
					}
					String v_description = vo.getV_description();
					vo.setV_description("");
					getview(vo, Module, resource, form, searchForm, pendingFilterScript, v_type[i]);
					vo.setV_description(v_description);
				} else {
					allFilterScript = formName;
					if (vo.getV_filter() != null && vo.getV_filter().length() > 0) {
						allFilterScript = wizardUtil.getV_filter(contextBasePath, vo, formName);
					}
					getview(vo, Module, resource, form, searchForm, allFilterScript, v_type[i]);
				}
			}
		}
	}

	/**
	 * 创建View的主体
	 * 
	 * @param vo
	 *            向导VO
	 * @param Module
	 *            模块VO
	 * @param resource
	 *            菜单VO
	 * @param form
	 *            主表单VO
	 * @param searchForm
	 *            查询模板VO
	 * @param filterscript
	 *            过滤脚本
	 * @param v_type
	 *            视图类型
	 * @throws Exception
	 */
	private void getview(WizardVO vo, Module Module, ResourceVO resource, Form form, Form searchForm,
			String filterscript, String v_type) throws Exception {
		AbstractView view = ViewDirector.construct(ViewConstant.VIEW_TYPE_NORMAL);
		view.setId(Sequence.getDesignTimeSequence());
		view.setApplicationid(vo.getApplicationid());
		view.setDescription(vo.getV_description());
		if (v_type != null && v_type.equalsIgnoreCase(WizardVO.VIEWDISPLAY_PENDING)) {
			view.setName(vo.getV_name() + "_" + WizardVO.VIEWDISPLAY_PENDING);
		} else {
			view.setName(vo.getV_name());
		}

		view.setOpenType(ViewConstant.OPEN_TYPE_NORMAL);
		view.setEditMode(ViewConstant.EDIT_MODE_CODE_DQL);
		view.setFilterScript(filterscript);
		view.setParent(Module);
		view.setParentId(Module.getId());
		view.setShowTotalRow(vo.getV_isShowTotalRow() == null ? false : vo.getV_isShowTotalRow().equalsIgnoreCase(
				"true"));
		view.setPagination(vo.getV_isPagination() == null ? false : vo.getV_isPagination().equalsIgnoreCase("true"));
		view.setPageLines(vo.getV_pagelines());
		if (searchForm != null) {
			Form _searchForm = new Form();
			_searchForm.setId(searchForm.getId());
			view.setSearchForm(_searchForm);
		}

		// 建立与相关的resource
		ResourceVO resourceVO = new ResourceVO();
		resourceVO.setActionContent(view.getId());
		resourceVO.setApplicationid(view.getApplicationid());
		resourceVO.setLinkName(view.getName());
		resourceVO.setLinkType(ResourceVO.LinkType.VIEW.getCode());
		resourceVO.setQueryString("[]");
		resourceVO.setModuleid(view.getParent().getId());
		resourceVO.setId(Sequence.getDesignTimeSequence());
		resourceVO.setSuperior(resource.getId());
		resourceVO.setApplicationid(vo.getApplicationid());
		resourceVO.setParentId(vo.getApplicationid());
		if (v_type == null || !v_type.equalsIgnoreCase(WizardVO.VIEWDISPLAY_PENDING)) {
			resourceVO.setDescription(vo.getV_description() + "_" + WizardVO.VIEWDISPLAY_ALL);
		}
		if(WizardVO.VIEWDISPLAY_PENDING.equalsIgnoreCase(v_type)){
			resourceVO.setDescription(vo.getV_name() + "_" + WizardVO.VIEWDISPLAY_PENDING);
		}
		resourceVO.setType(ResourceType.RESOURCE_TYPE_MENU);

		view.setRelatedResourceId(resourceVO.getId());
		
		viewService.doCreate(view);
		resourceService.saveOrUpdate(resourceVO);

		// 建立与view相关的column
		getAllColumn(vo, view, form, vo.getApplicationid());
		/*List<Column> v_cloumn = getAllColumn(vo, view, form, vo.getApplicationid());
		for (Iterator<Column> iter = v_cloumn.iterator(); iter.hasNext();) {
			Column column = iter.next();
			view.getColumns().add(column);
		}*/

		// 建立与view相关的activity
		ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
		Activity act = null;
		if (v_type != null && v_type.equalsIgnoreCase(WizardVO.VIEWDISPLAY_ALL)) {
			String[] v_activity = vo.getV_activity();
			if (v_activity != null && v_activity.length > 0) {
				for (int i = 0; i < v_activity.length; i++) {
					act = new Activity();
					act.setId(Sequence.getDesignTimeSequence());
					act.setName((String) WizardVO._VIEWACLIST.get(v_activity[i]));
					act.setType(Integer.parseInt(v_activity[i]));
					if (v_activity[i].equals("1") || v_activity[i].equals("16")) {
						act.setOnActionView(view.getId());
					} else if (v_activity[i].equals("2") || v_activity[i].equals("4")) {
						act.setOnActionForm(form.getId());
						// act.setParentForm(form);
					}
					act.setParentView(view.getId());
					act.setOrderno(i + 1);
					act.setApplicationid(vo.getApplicationid());
					act.setParent(view);
					act.setParentId(view.getId());
					activityService.save(act);
				}
			}
		}
//		viewService.doUpdate(view);
	}

	/**
	 * 创建菜单
	 * 
	 * @param vo
	 *            向导VO
	 * @param Module
	 *            模块VO
	 * @return 创建好后的菜单VO
	 * @throws Exception
	 */
	private ResourceVO createResource(WizardVO vo, Module Module) throws Exception {
		ResourceVO resource = new ResourceVO();

		resource.setId(Sequence.getDesignTimeSequence());
		resource.setApplicationid(vo.getApplicationid());
		resource.setDescription(vo.getR_description());
		resource.setOrderno(vo.getR_orderno());
		resource.setType(ResourceType.RESOURCE_TYPE_MENU);
		resource.setParentId(vo.getApplicationid());
		if (!vo.getR_superior().equals(""))
			resource.setSuperior(vo.getR_superior());

		resourceService.doCreate(resource);
		return resource;
	}

	/**
	 * 创建主菜单
	 * 
	 * @param wizardvo
	 *            向导VO
	 * @param Module
	 *            模块VO
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @return 创建好的表单VO
	 * @throws Exception
	 */
	private Form createMainForm(WizardVO wizardvo, Module Module, String contextBasePath) throws Exception {
		ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
		Form form = null;

		Activity act;
		// 创建Form
		if (wizardvo.getF_formid() == null || wizardvo.getF_formid().trim().length() == 0) {
			form = new Form();
			form.setApplicationid(wizardvo.getApplicationid());
			form.setModule(Module);
			form.setDescription(wizardvo.getF_description());
			form.setName(wizardvo.getF_name());
			form.setTemplatecontext(wizardUtil.getF_TemplateContext(wizardvo.getF_templatecontext(), wizardvo
					.getF_style(), contextBasePath));
			form.setSortId(Sequence.getTimeSequence());
			form.setType(Form.FORM_TYPE_NORMAL);
			form.setParent(Module);
			form.setParentId(Module.getId());
			formService.doCreate(form);

			// 根据提交回来的信息，新建表单的Activity
			String[] f_activitys = wizardvo.getF_activitys();
			if (f_activitys != null && f_activitys.length > 0) {
				for (int i = 0; (i < f_activitys.length)
						&& !(f_activitys[i].equals(String.valueOf(ActivityType.WORKFLOW_PROCESS))); i++) {
					act = new Activity();
					act.setId(Sequence.getDesignTimeSequence());
					act.setName((String) WizardVO._FORMACLIST.get(f_activitys[i]));
					act.setType(Integer.parseInt(f_activitys[i]));
					act.setOnActionForm(form.getId());
					act.setApplicationid(wizardvo.getApplicationid());
					act.setOrderno(i + 1);
					act.setParentForm(form.getId());
					act.setParent(form);
					act.setParentId(form.getId());
					activityService.save(act);
				}
//				formService.doUpdate(form);

			}
		}
		return form;
	}

	/**
	 * 创建子表单
	 * 
	 * @param wizardvo
	 *            向导VO
	 * @param Module
	 *            模块VO
	 * @param contextBasePath
	 *            当前应用的相对路径
	 * @return 创建好的子表单VO
	 * @throws Exception
	 */
	private Form createSubForm(WizardVO wizardvo, Module Module, String contextBasePath) throws Exception {
		ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
		Form form = null;

		Activity act;
		// 创建Form
		if (wizardvo.getF_formId_sub() == null || wizardvo.getF_formId_sub().trim().length() == 0) {
			form = new Form();
			form.setApplicationid(wizardvo.getApplicationid());
			form.setModule(Module);
			form.setDescription(wizardvo.getF_description_sub());
			form.setName(wizardvo.getF_name_sub());
			form.setTemplatecontext(wizardUtil.getF_TemplateContext(wizardvo.getF_fieldsdescription_sub(), wizardvo
					.getF_style_sub(), contextBasePath));
			form.setSortId(Sequence.getTimeSequence());
			form.setType(Form.FORM_TYPE_NORMAL);
			form.setParent(Module);
			form.setParentId(Module.getId());
			formService.doCreate(form);

			// 根据提交回来的信息，新建表单的Activity
			String[] f_activitys = wizardvo.getF_activitys_sub();
			if (f_activitys != null && f_activitys.length > 0) {
				for (int i = 0; (i < f_activitys.length)
						&& !(f_activitys[i].equals(String.valueOf(ActivityType.WORKFLOW_PROCESS))); i++) {
					act = new Activity();
					act.setId(Sequence.getDesignTimeSequence());
					act.setName((String) WizardVO._FORMACLIST.get(f_activitys[i]));
					act.setType(Integer.parseInt(f_activitys[i]));
					act.setOnActionForm(form.getId());
					act.setParentForm(form.getId());
					act.setOrderno(i + 1);
					act.setApplicationid(wizardvo.getApplicationid());
					act.setParent(form);
					act.setParentId(form.getId());
					activityService.save(act);
				}
//				formService.doUpdate(form);

			}
		}
		return form;
	}

	/**
	 * 创建模块
	 * 
	 * @param vo
	 *            向导VO
	 * @param applicationid
	 *            当前应用ID
	 * @return 创建好的模块VO
	 * @throws Exception
	 */
	private Module createModule(WizardVO vo, String applicationid) throws Exception {
		Module Module = new Module();
		Application appvo = (Application) applicationProcess.findById(applicationid);
		if (vo.getModuleid() == null || vo.getModuleid().trim().length() == 0) {
			Module.setId(Sequence.getDesignTimeSequence());
			Module.setApplicationid(appvo.getId());
			Module.setParentId(appvo.getId());
			Module.setName(vo.getM_name());
			Module.setDescription(vo.getM_description());
			moduleProcess.save(Module);
		} else {
			Module = (Module) moduleProcess.findById(vo.getModuleid());
			if (Module != null) {
				Module.setName(vo.getM_name());
				Module.setDescription(vo.getM_description());
				moduleProcess.update(Module);
			}

		}
		if (Module != null)
			vo.setModuleid(Module.getId());
		return Module;
	}

	/**
	 * 获取所有的列字段
	 * 
	 * @param wizardvo
	 *            向导VO
	 * @param view
	 *            视图VO
	 * @param form
	 *            表单VO
	 * @param applicationid
	 *            当前应用的ID
	 * @return 视图的所有列字段的集合
	 * @throws Exception
	 */
	private List<Column> getAllColumn(WizardVO wizardvo, AbstractView view, Form form, String applicationid) throws Exception {
		ColumnDesignTimeService service = DesignTimeServiceManager.columnDesignTimeService();
		List<Column> v_cloumns = new ArrayList<Column>();

		// 设置column列
		String[] fields = null;
		if (wizardvo.getV_columns().trim().length() > 0 && !wizardvo.getV_columns().equals("")) {
			fields = wizardvo.getV_columns().split(";");
		}
		if (fields != null) {// && fields.length > 0 && !"".equals(fields)
			for (int i = 0; i < fields.length; i++) {
				Column columns = new Column();
				columns.setOrderno(i);
				columns.setFormid(form.getId());
				columns.setApplicationid(applicationid);
				columns.setParentView(view.getId());
				columns.setFieldName(fields[i]);
				columns.setName(fields[i]);
				columns.setId(Sequence.getDesignTimeSequence());
				columns.setParent(view);
				columns.setParentId(view.getId());
				service.save(columns);
				v_cloumns.add(columns);
			}
		}
		return v_cloumns;
	}
}