package cn.myapps.designtime.versions.controller;

import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.versions.Versions;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.versions.service.VersionsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(tags = "公共设计模块")
@Component
@RequestMapping(path = "/api/designtime", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class VersionsController extends AbstractDesignTimeController {

    private VersionsService versionsService;

    public VersionsController() throws Exception {
        versionsService = DesignTimeServiceManager.versionsService();
    }

    /**
     * 获取系统信息列表（可根据名称或者类型查询）
     *
     * @param name  名称
     * @param type  类型
     * @param currpage  当前页数
     * @param pagelines 每页行数
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/systeminfo")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取系统信息列表", notes = "获取系统信息列表（可根据名称或者类型查询）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "名称", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "type", value = "类型", required = false, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = "currpage", value = "当前页数", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "pagelines", value = "每页行数", required = true, paramType = "query", dataType = "string"),
    })
    public Resource doGetVersionsList(@RequestParam(required = false) String name, @RequestParam(required = false,defaultValue = "0")int type,
                                   String currpage, String pagelines) throws Exception {
        int page = (currpage != null && currpage.length() > 0) ? Integer.parseInt(currpage) : 1;
        int line = (pagelines != null && pagelines.length() > 0) ? Integer.parseInt(pagelines) : 10;
        try {
            DataPackage<Versions> versions = versionsService.query(null, name, type == 0 ? null : type, page, line);
            return success("ok", versions);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

}
