package cn.myapps.designtime.superuser.controller;

import static com.jayway.jsonpath.JsonPath.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.bcxin.saas.core.exceptions.SaasUnAuthorizeException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.constans.Web;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@Api(tags = "开发者设计模块")
@Component
@RequestMapping(path = "/api/designtime/applications", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SuperUserController extends AbstractDesignTimeController {

    SuperUserDesignTimeService superUserProcess;
    ApplicationDesignTimeService appService;

    public SuperUserController() throws Exception {
        superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
        appService = DesignTimeServiceManager.applicationDesignTimeService();
    }

    /**
     * 获取已加入软件的开发者列表
     *
     * @param applicationId 软件id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/{applicationId}/superusers/join")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取已加入软件的开发者列表", notes = "获取已加入软件的开发者列表（可根据名字或者账号查询）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "name", value = "查询名称", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "loginno", value = "查询账号", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "pageNo", value = "当前页数", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "linesPerPage", value = "每页行数", required = false, paramType = "query", dataType = "string"),
    })
    public Resource doGetJoinDeveloperList(@PathVariable String applicationId, @RequestParam(required = false) String name, @RequestParam(required = false) String loginno,
                                       @RequestParam(required = false) String pageNo, @RequestParam(required = false) String linesPerPage) throws Exception {
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        int line = (linesPerPage != null && linesPerPage.length() > 0) ? Integer.parseInt(linesPerPage) : 10;
        try {
            ParamsTable params = getParams();
            params.setParameter("id", applicationId);
            params.setParameter("sm_name", name);
            params.setParameter("sm_loginno", loginno);
            params.setParameter("_currpage", page);
            params.setParameter("_pagelines", line);
            DataPackage<SuperUserVO> superUsers = superUserProcess.getJoinedDeveloperList(params);

            return success("ok", superUsers);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取未加入软件的开发者列表
     *
     * @param applicationId 软件id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/{applicationId}/superusers/unjoin")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取未加入软件的开发者列表", notes = "获取未加入软件的开发者列表（可根据名字或者账号查询）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "name", value = "查询名称", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "loginno", value = "查询账号", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "pageNo", value = "当前页数", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "linesPerPage", value = "每页行数", required = false, paramType = "query", dataType = "string"),
    })
    public Resource doGetUnjoinDeveloperList(@PathVariable String applicationId, @RequestParam(required = false) String name, @RequestParam(required = false) String loginno,
                                             @RequestParam(required = false) String pageNo, @RequestParam(required = false) String linesPerPage) throws Exception {
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        int line = (linesPerPage != null && linesPerPage.length() > 0) ? Integer.parseInt(linesPerPage) : 10;
        try {
            ParamsTable params = getParams();
            params.setParameter("id", applicationId);
            params.setParameter("sm_name", name);
            params.setParameter("sm_loginno", loginno);
            params.setParameter("_currpage", page);
            params.setParameter("_pagelines", line);
            DataPackage<SuperUserVO> superUsers = superUserProcess.getUnjoinedDeveloperList(params);
            return success("ok", superUsers);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 添加开发者（可批量）
     *
     * @param applicationId 软件id
     * @param content  请求包体
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/{applicationId}/superusers")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "添加开发者", notes = "添加开发者（可批量）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doAddDeveloper(@PathVariable String applicationId, @RequestBody String content) throws Exception {

        try {
            List<String> ids = parse(content).json();
            String[] idArray = {};
            idArray = ids.toArray(idArray);
            if (idArray != null && idArray.length > 0) {
                for (int i = 0; i < idArray.length; i++) {
                    SuperUserVO su = superUserProcess.doView(idArray[i]);
                    if (su != null) {
                        Collection<String> apps = su.getApplications();
                        if (apps == null) {
                            apps = new ArrayList<String>();
                        }
                        apps.add(applicationId);
                        su.setApplications(apps);
                        superUserProcess.doUpdate(su);
                    }
                }
            }

            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 移除开发者（可批量）
     *
     * @param applicationId 软件id
     * @param content 请求包体
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/{applicationId}/superusers")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "移除开发者", notes = "移除开发者（可批量）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doRemoveDeveloper(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            List<String> ids = parse(content).json();
            String[] idArray = {};
            idArray = ids.toArray(idArray);
            if (idArray != null && idArray.length > 0) {
                for (int i = 0; i < idArray.length; i++) {
                    SuperUserVO su = superUserProcess.doView(idArray[i]);
                    if(su!=null){
                        Collection<String> apps = su.getApplications();
                        Iterator<String> it = apps.iterator();
                        while(it.hasNext()){
                            if(applicationId.equals(it.next())){
                                it.remove();
                            }
                        }
                        superUserProcess.doUpdate(su);
                    }
                }
            }

            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取特权用户信息
     * @return
     */
    @GetMapping(path = "/getSuperuser")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取特权用户信息", notes = "获取特权用户信息")
    public Resource getSuperUser(){
		SuperUserDesignTimeService sprocess =  DesignTimeServiceManager.superUserDesignTimeService();
		String userId = Security.getDesignerIdFromToken(request);

		WebUser webUser;
		JSONObject user = new JSONObject();
		try {
			webUser = sprocess.getWebUserInstance(userId);
            if(webUser==null) {
                throw new SaasUnAuthorizeException(String.format("用户信息无效(userId=%s;)", userId));
            }

	        user.put("id",webUser.getId());
	        user.put("name",webUser.getName());
	        user.put("loginno",webUser.getLoginno());
	        user.put("loginpwd",webUser.getLoginpwd());
	        user.put("email",webUser.getEmail());
            user.put("license", Environment.licenseType);
		} catch (Exception e) {
			e.printStackTrace();
		}
        return success("ok", user);
    }

    /**
     * 修改特权用户信息
     * @return
     */
    @PutMapping(path = "/superuser/{userId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "修改特权用户信息", notes = "修改特权用户信息")
    @ApiImplicitParams({
          @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource updateSuperUser(@RequestBody String content,@PathVariable String userId){
        try{
            JSONObject json = JSONObject.fromObject(content);
            //SuperUserVO superUserVO = (SuperUserVO)json2obj(json,SuperUserVO.class);
            SuperUserVO superUserVO = superUserProcess.doView(userId);
            superUserVO.setName((String)json.get("name"));
            superUserVO.setEmail((String)json.get("email"));
            superUserVO.setLoginno((String)json.get("loginno"));
            String loginPw = (String)json.get("loginpwd");
            if(!loginPw.equals(Web.DEFAULT_SHOWPASSWORD)){
                superUserVO.setLoginpwd(Security.encryptPassword(loginPw));
            }
            //解密操作
//            if(loginPw!=null && loginPw.length()>2 && !loginPw.equals("888888qqqq")){
//                String lp = loginPw.substring(0, loginPw.length()-2);
//                String rp = loginPw.substring(loginPw.length()-2,loginPw.length());
//                loginPw = Security.decodeBASE64(rp+lp);
//                superUserVO.setLoginpwd(loginPw);
//            }
            superUserProcess.doPersonalUpdate(superUserVO);
            return success("ok", superUserVO);
        }catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }
}
