package cn.myapps.designtime.menu.controller;

import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.util.StringUtil;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceUtil {

	/**
	 * 根据菜单的集合生成菜单并以树(Tree)形式的集合.
	 *
	 * @param cols
	 *            菜单的集合
	 * @param startNode
	 *            菜单的开始节点
	 * @param excludeNodeId
	 *            不包括的节点
	 * @param deep
	 *            深入级别
	 * @return 树(Tree)形式的菜单集合
	 * @throws Exception
	 */
	public static Map<String, String> deepSearchMenuTree(Collection<ResourceVO> cols,
														 ResourceVO startNode, String excludeNodeId, int deep)
			throws Exception {
		Map<String, String> list = new LinkedHashMap<String, String>();

		String prefix = "|------------------------------------------------";

		Iterator<ResourceVO> iter = cols.iterator();

		//为空时,查询主菜单
		if(startNode == null) {
			if(!StringUtil.isBlank(excludeNodeId) && "none".equals(excludeNodeId)){
				list.put("", "请选择PC菜单");
			} else {
				list.put("", "无");
			}
			while (iter.hasNext()) {
				ResourceVO vo = iter.next();

				if(vo.getId().equals(excludeNodeId)){
					continue;
				}
				if(vo.getParent() instanceof Application){
					if(!vo.getId().equals(excludeNodeId)){
						list.put(vo.getId(),prefix.substring(0,deep*2) +  vo.getName());
					}
					//查询主菜单下的子菜单
					Map<String,String> tmp = deepSearchMenuTree(cols,vo,excludeNodeId,deep+2);
					list.putAll(tmp);
				}

			}
		}

		//查询子菜单的子菜单
		if(startNode != null) {
			iter = cols.iterator();
			while(iter.hasNext()) {
				ResourceVO vo = iter.next();

				if(vo.getId().equals(excludeNodeId)){
					continue;
				}

				if(startNode.getId().equals(vo.getSuperior())) {
					list.put(vo.getId(),prefix.substring(0,deep*2) + vo.getName());
					Map<String,String> tmp = deepSearchMenuTree(cols,vo,excludeNodeId,deep+2);
					list.putAll(tmp);
				}
			}
		}

		return list;
	}
}