package cn.myapps.designtime.login.controller;

import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;

import cn.myapps.common.util.Base64Util;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.Random;

/**
 * 登陆模块
 */
@Component
@RequestMapping(value = "/api/designtime")
@Scope("prototype")
public class LoginDesignTimeController extends AbstractDesignTimeController {

    private String CheckCode_Session = "CheckCode";

    private static int WIDTH = 60;

    private static int HEIGHT = 20;
    /**
     * designer登陆
     * @param content
     * @return
     */
    @PostMapping("/login")
    @ApiOperation(value = "designer登陆", notes = "designer登陆")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "登陆数据包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource login(@RequestBody String content){
        int count = 0;
        SuperUserDesignTimeService superProcess = null;
        SuperUserVO originUser = null;
        String png_base64 = "";
        try {
            JSONObject json = JSONObject.fromObject(content);
            String username = (String) json.get("username");
            String password = (String) json.get("password");
            String checkcode = json.getString("checkcode");

            if(password!=null && password.length()>2){
                String lp = password.substring(0, password.length()-2);
                String rp = password.substring(password.length()-2,password.length());
                password = Security.decodeBASE64(rp+lp);
            }

            superProcess = DesignTimeServiceManager.superUserDesignTimeService();

            originUser = superProcess.doViewByLoginno(username);
            count = originUser.getPwdErrorTimes();
            if (count > 2) {
                String code = (String) request.getSession().getAttribute(CheckCode_Session);
                if (code != null && !code.equalsIgnoreCase(checkcode)) {
                    png_base64 = "data:image/jpg;base64," + getCheckCodeImg();
                    JSONObject result = new JSONObject();
                    result.put("checkcodeImg",png_base64);
                    return error(1,"输入字符错误，请重新输入图片中出现的4个字符",result,null);
                }
            }
            if (count >= 2) {
                png_base64 = "data:image/jpg;base64," + getCheckCodeImg();
            }
            SuperUserVO user = superProcess.login(username, password);

//            WebUser webUser = null;
            String token = null;
            if (user != null && user.getStatus() == 1) {
//                webUser = new WebUser(user);
//                AuthTimeServiceManager.setDesignerUser(webUser, session);

                token = Security.getToken(user.getId());
                // 存放到cookie
                Cookie cookie = new Cookie(Security.DESIGNER_TOKEN, token);
                cookie.setPath("/");
                response.addCookie(cookie);
            } else {
                if(originUser != null){
                    originUser.setPwdErrorTimes(++count);
                    if(count > 10){
                        originUser.setStatus(0);
                    }
                    superProcess.doUpdate(originUser);
                }
                JSONObject result = new JSONObject();
                result.put("checkcodeImg",png_base64);
                return error(1,"账号或密码错误!",result,null);
            }
            if(originUser != null){
                originUser.setPwdErrorTimes(0);
                superProcess.doUpdate(originUser);
            }
            JSONObject result = new JSONObject();
            result.put(Security.DESIGNER_TOKEN, token);

            return success("ok", result);
        } catch (Exception e) {
            if(originUser != null){
                originUser.setPwdErrorTimes(++count);
                if(count > 10){
                    originUser.setStatus(0);
                }
                try {
                    superProcess.doUpdate(originUser);
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            JSONObject result = new JSONObject();
            result.put("checkcodeImg",png_base64);
            return error(1,"账号或密码错误!",result,null);
        }
    }

    /**
     * 注销登陆
     * @return
     * @throws Exception
     */
    @PostMapping("/logout")
    @ApiOperation(value = "注销登陆", notes = "注销登陆")
    public Resource logout(){
        try {
            String designerId = Security.getDesignerIdFromToken(request);
            //AuthTimeServiceManager.removeAdminUser(designerId);
            Cookie cookie = new Cookie(Security.DESIGNER_TOKEN, "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
    public String getCheckCodeImg() throws Exception {
        String png_base64;
        response.setContentType("image/jpg");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        // 创建内存图象并获得其图形上下文
        BufferedImage image = new BufferedImage(WIDTH + 6, HEIGHT + 4, BufferedImage.TYPE_INT_RGB);
        Graphics g = image.getGraphics();
        // 产生随机的认证码
        char[] rands = generateCheckCode();
        // 产生图像
        drawBackground(g);
        drawRands(g, rands);
        g.dispose();
        // 转base64
        ByteArrayOutputStream baos = new ByteArrayOutputStream();// io流
        ImageIO.write(image, "JPG", baos);// 写入流中
        byte[] bytes = baos.toByteArray();// 转换成字节
        png_base64 = Base64Util.encode(bytes);// 转换成base64串
        // 删除 \r\n
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        request.getSession().setAttribute(CheckCode_Session, String.valueOf(rands));
        return png_base64;
    }
    /**
     * 画干扰背景
     *
     * @param
     */
    private void drawBackground(Graphics gd) {
        // 创建一个随机数生成器类
        Random r = new Random();
        gd.setColor(Color.black);
        gd.clipRect(0, 0, WIDTH + 6, HEIGHT + 4);
        // 画背景
        gd.setColor(Color.white);
        gd.fillRect(1, 1, WIDTH + 4, HEIGHT + 2);
        // 随机干扰点
//		for (int x = 3; x < WIDTH + 4; x += 4) {
//			for (int y = 2; y < HEIGHT + 3; y += 3) {
//				gd.setColor(Color.black);
//				gd.drawOval(x, y, 1, 0);
//			}
//		}
        // 随机产生160条干扰线，使图象中的认证码不易被其它程序探测到。
        for (int i = 0; i < 30; i++) {
            int x = r.nextInt(WIDTH) + 2;
            int y = r.nextInt(HEIGHT) + 3;
            int xl = r.nextInt(12);
            int yl = r.nextInt(12);
            // 产生随机的颜色分量来构造颜色值，这样输出的每位数字的颜色值都将不同。
            int red = r.nextInt(255);
            int green = r.nextInt(255);
            int blue = r.nextInt(255);

            // 用随机产生的颜色将验证码绘制到图像中。
            gd.setColor(new Color(red, green, blue));
            gd.drawLine(x, y, x + xl, y + yl);
        }
    }

    /**
     * 生成图片
     *
     * @param g
     * @param rands
     */
    private void drawRands(Graphics g, char[] rands) {
        g.setColor(new Color(0x1f1f1f));
        // 创建字体，字体的大小应该根据图片的高度来定。
        Font font = new Font("Fixedsys", Font.PLAIN, HEIGHT);
        // 设置字体。
        g.setFont(font);
        int xx = WIDTH / (rands.length + 1);
        int codeY = HEIGHT;
        for (int i = 0; i < rands.length; i++) {
            g.drawString("" + rands[i], (i + 1) * xx, codeY);
        }
    }

    private char[] generateCheckCode() {
        // 定义验证码的字符表
        // 考虑到1和l难以区分,将l大写为L
        String chars = "0123456789abcdefghijkLmnopqrstuvwxyz";

        char[] rands = new char[4];
        for (int i = 0; i < 4; i++) {
            // int rand = Double.valueOf(Math.random() * 36).intValue();
            int rand = new Random().nextInt(36);
            rands[i] = chars.charAt(rand);
        }

        return rands;
    }
}
