package cn.myapps.designtime.fckeditor.connector;
import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.tool.UtilsFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;


public abstract class AbstractLocalFileSystemConnector implements Connector {
    protected ServletContext servletContext;

    public AbstractLocalFileSystemConnector() {
    }

    public String fileUpload(ResourceType type, String currentFolder, String fileName, InputStream inputStream) throws InvalidCurrentFolderException, WriteException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (currentDir.exists() && currentDir.isDirectory()) {
            File newFile = new File(currentDir, fileName);
            File fileToSave = UtilsFile.getUniqueFile(newFile.getAbsoluteFile());

            try {
                IOUtils.copyLarge(inputStream, new FileOutputStream(fileToSave));
            } catch (IOException var11) {
                throw new WriteException();
            }

            return fileToSave.getName();
        } else {
            throw new InvalidCurrentFolderException();
        }
    }

    public void createFolder(ResourceType type, String currentFolder, String newFolder) throws InvalidCurrentFolderException, InvalidNewFolderNameException, FolderAlreadyExistsException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (currentDir.exists() && currentDir.isDirectory()) {
            File newDir = new File(currentDir, newFolder);
            if (newDir.exists()) {
                throw new FolderAlreadyExistsException();
            } else if (!newDir.mkdir()) {
                throw new InvalidNewFolderNameException();
            }
        } else {
            throw new InvalidCurrentFolderException();
        }
    }

    public List<Map<String, Object>> getFiles(ResourceType type, String currentFolder) throws InvalidCurrentFolderException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (currentDir.exists() && currentDir.isDirectory()) {
            File[] fileList = currentDir.listFiles((FileFilter) FileFileFilter.FILE);
            List<Map<String, Object>> files = new ArrayList(fileList.length);
            File[] arr$ = fileList;
            int len$ = fileList.length;

            for(int i$ = 0; i$ < len$; ++i$) {
                File file = arr$[i$];
                Map<String, Object> fileMap = new HashMap(2);
                fileMap.put("name", file.getName());
                fileMap.put("size", new Long(file.length()));
                files.add(fileMap);
            }

            return files;
        } else {
            throw new InvalidCurrentFolderException();
        }
    }

    public List<String> getFolders(ResourceType type, String currentFolder) throws InvalidCurrentFolderException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (currentDir.exists() && currentDir.isDirectory()) {
            String[] fileList = currentDir.list(DirectoryFileFilter.DIRECTORY);
            return Arrays.asList(fileList);
        } else {
            throw new InvalidCurrentFolderException();
        }
    }

    protected abstract String getRealUserFilesAbsolutePath(String var1);

    protected static File getOrCreateResourceTypeDir(String baseDir, ResourceType type) {
        File dir = new File(baseDir, type.getPath());
        if (!dir.exists()) {
            dir.mkdirs();
        }

        return dir;
    }
}
