package cn.myapps.designtime.common.controller;

import java.io.File;
import java.util.Calendar;
import java.util.UUID;

import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@RestController
@RequestMapping(value = {"/api/designtime/applications"})
@Scope("prototype")
public class UploadDesignTimeController extends AbstractDesignTimeController{

    /**
     * 文件上传
     * @param multipartFiles 多个文件
     * @return
     * @throws Exception
     */
    @PostMapping("/uploads")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "文件上传", notes = "文件上传")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "multipartFiles",value = "多个文件",required = true,paramType = "query",dataType = "string")
    })
    public Resource upload(@RequestParam("file") MultipartFile[] multipartFiles)
            throws Exception {
        String savePath ="";
        String fileName ="";
        String extName ="";
        ParamsTable params = getParams();
        boolean icon = params.getParameterAsBoolean("icon");
        String path = params.getParameterAsString("path");
        int year = 0;
        Calendar cal = Calendar.getInstance();
        year = cal.get(Calendar.YEAR);
        // 生成唯一id
        String id = UUID.randomUUID().toString();
        JSONArray result = new JSONArray();
        if (multipartFiles.length > 0) {
            for (int i = 0; i < multipartFiles.length; i++) {
                // 获取上传文件
                MultipartFile multipartFile = multipartFiles[i];
                // 获取上传文件名
                fileName = multipartFile.getOriginalFilename();
                // 获取上传文件大小
//                Long size = multipartFile.getSize();
                // 获取上传文件拓展名
                extName = fileName.substring(fileName.indexOf(".") + 1);

                // 获得文件保存的真实路径
                if(StringUtil.isBlank(path)){
                    savePath = PropertyUtil.getPath()+"/"+"uploads"+"/";
                    savePath += year;
                }else {
                    savePath = PropertyUtil.getPath()+path+"/";
                }

                // 文件夹不存在就创建
                File dir = new File(savePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }


                if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {// 防止非法上传文件到任意目录
                    throw new OBPMValidateException("上传的文件名称不合法！");
                }
                if (isNotLegalFileExt(extName)) {
                    return error(4001, "上传的文件类型不合法！", null);
                }

                // 生成文件
                File f ;
                if(!icon){
                    f = new File(savePath + "/" + id + "." + extName);
                }else {
                    f = new File(savePath + "/" + fileName);
                    if(f.exists()){
                        f.delete();
                        //return error(500, "文件已经存在", null);
                    }
                }

                f.createNewFile();
                multipartFile.transferTo(f);

            }
            JSONObject responseInfoItem = new JSONObject();
            responseInfoItem.put("fileName", fileName);
            if(!icon){
                responseInfoItem.put("filePath", "/"+"uploads"+"/" +year+"/"+ id + "." + extName);
            }else {
                responseInfoItem.put("filePath",path+"/"+ fileName);
            }

            result.add(responseInfoItem);
        }
        return success("ok",result);
    }

    /**
     * 是否为不合法文件类型
     *
     * @param fileExt
     * @throws Exception
     */
    private boolean isNotLegalFileExt(String fileExt) throws Exception {
        String[] excludeTypes = new String[] { "jsp", "class" ,"jspx" };
        if (StringUtil.isBlank(fileExt))
            return true;
//		String fileType = fileExt.substring(1);
        String fileType = fileExt;
        for (int i = 0; i < excludeTypes.length; i++) {
            String excludeType = excludeTypes[i];
            if (StringUtil.isBlank(excludeType))
                continue;
            if (fileType.equalsIgnoreCase(excludeType))
                return true;
        }
        return false;
    }


}
