package cn.myapps.designtime.common.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Collection;

/**
 * Restful 接口返回的资源对象
 * 
 * @author ahan
 *
 */
@JsonInclude(Include.NON_EMPTY)
@ApiModel
public class Resource implements Serializable {

	private static final long serialVersionUID = 2315158311944949185L;

	@ApiModelProperty(name = "errcode",value = "返回状态码")
	private int errcode;

	@ApiModelProperty(name = "errmsg",value = "返回信息")
	private String errmsg;

	@ApiModelProperty(name = "data",value = "返回的json数据")
	private Object data;

	@ApiModelProperty(name = "errors", value = "错误信息")
	private Collection<ErrorMessage> errors;

	public Resource() {}
	
	public Resource(int errcode, String errmsg, Object data, Collection<ErrorMessage> errors) {
		this.errcode = errcode;
		this.errmsg = errmsg;
		this.data = data;
		this.errors = errors;
	}

	public Resource(int errcode, String errmsg, Object data) {
		this.errcode = errcode;
		this.errmsg = errmsg;
		this.data = data;
		this.errors = null;
	}
	
	public Resource(int errcode, String errmsg) {
		this.errcode = errcode;
		this.errmsg = errmsg;
		this.data = null;
		this.errors = null;
	}
	
	public int getErrcode() {
		return errcode;
	}

	public void setErrcode(int errcode) {
		this.errcode = errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public Collection<ErrorMessage> getErrors() {
		return errors;
	}

	public void setErrors(Collection<ErrorMessage> errors) {
		this.errors = errors;
	}

}
