package cn.myapps.designtime.common.controller;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

import com.jayway.jsonpath.PathNotFoundException;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.constans.Web;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import net.sf.json.JSONObject;

/**
 * 定义了基本的Restful接口信息，用于处理共同的错误返回码以及其他信息
 * 对应资源的Restful接口需要实现这个抽象类并定义为一个 {@link Component}便可由spring自动扫描装配
 */
@RestController
public abstract class AbstractDesignTimeController {

    @Autowired
    protected HttpServletRequest request;

    @Autowired
    protected HttpServletResponse response;

    @Autowired
    protected HttpSession session;

    /**
     * Retrieve WebUser Object.
     *
     * @return The current WebUser Object.
     * @throws Exception
     */
    protected WebUser getUser() throws Exception {
		SuperUserDesignTimeService sprocess =  DesignTimeServiceManager.superUserDesignTimeService();
		String userId = Security.getDesignerIdFromToken(request);

		WebUser webUser = null;
		try {
			webUser = sprocess.getWebUserInstance(userId);
		} catch (Exception e) {
			e.printStackTrace();
		}
        
        return webUser;
    }

    /**
     * Retrieve the ParamsTable
     *
     * @return ParamsTable
     */
    public ParamsTable getParams() {
        ParamsTable pm = ParamsTable.convertHTTP(request);

        // put the page line count id to parameters table.
        if (pm.getParameter("_pagelines") == null)
            pm.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);

        return pm;
    }

    protected Resource success(String errmsg, Object data) {
        return new Resource(0, errmsg, data, null);
    }


    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, null, errors);
    }

    protected Resource error(int errcode, String errmsg, Object data,Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, data, errors);
    }
    /**
     * 传参错误。
     *
     * @param e
     * @return
     */
    @ExceptionHandler(MethodArgumentTypeMismatchException.class)
    @ResponseStatus(HttpStatus.NOT_ACCEPTABLE)
    public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
        return error(40035, "不合法的参数", null);
    }

    /**
     * 请求包体解析错误。
     *
     * @param e
     * @return
     */
    @ExceptionHandler(PathNotFoundException.class)
    @ResponseStatus(HttpStatus.NOT_ACCEPTABLE)
    public Resource requestbodyError(PathNotFoundException e) {
        e.printStackTrace();
        return error(406, "请求包体参数出错", null);
    }

    /*
     *
     *
     * json包体转对象
     *
     * */
    public Object json2obj(JSONObject json, Class c) throws Exception{
        Object o =c.newInstance();
        final Map<String, Class<?>> fieldsMap = getObjectToMap(o);
        Iterator<Map.Entry<String,Class<?>>> it = fieldsMap.entrySet().iterator();
        while (it.hasNext()){
            final Map.Entry<String, Class<?>> next = it.next();
            Object value = json.get(next.getKey());
            boolean flag =false;
            if(value instanceof Integer){
                flag = true;
                value = (int)value;
            }else if(value instanceof String){
                flag = value == null ? false:true;
                value = (String)value;
            }else if(value instanceof Boolean){
                flag =true;
                value = (Boolean)value;
            }
            if(next.getValue().toString().equals("class java.util.Date")){
                if(value!=null&&!StringUtil.isBlank(value.toString())){
                    String formatStr ;
                    if(String.valueOf(value).contains("T")){
                        formatStr = "yyyy-MM-dd'T'HH:mm:ss";
                    }else{
                        formatStr = "yyyy-MM-dd HH:mm:ss";
                    }
                    SimpleDateFormat format = new SimpleDateFormat(formatStr);
                    value = format.parse(String.valueOf(value));
                }
            }
            if(flag){
                Method method = c.getMethod("set" + next.getKey().substring(0, 1).toUpperCase() + next.getKey().substring(1),
                        next.getValue());
                method.invoke(o,value);
            }
        }
        return o;
    }

    public static Map<String,Class<?>> getObjectToMap(Object t) throws IllegalAccessException {
        Class className = t.getClass();
        Map<String,Class<?>> param=new HashMap<>();
        for(; className != Object.class ; className = className.getSuperclass()) {//获取本身和父级对象
            Field[] fields = className.getDeclaredFields();//获取所有私有字段
            for (Field field : fields) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                param.put(field.getName(), type);
            }
        }
        return param;
    }
}
