package cn.myapps.designtime.activity.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityType;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.web.DWRHtmlUtils;
import cn.myapps.util.xml.XmlUtil;

public class ActivityUtil {
	/**
	 * 根据模块主键与应用标识查询,返回视图集合
	 * 
	 * @param moduleid
	 *            模块主键
	 * @param application
	 * 应用标识
	 * @return 视图集合
	 * @throws Exception
	 */
	public Map<String, String> getViewByModule(String moduleid,
			String application) throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		if (moduleid.equals("")) {
			return map;
		}
		ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
		Collection<AbstractView> col = vp.getViewsByModule(moduleid, application);

		Iterator<AbstractView> it = col.iterator();
		while (it.hasNext()) {
			AbstractView vw = (AbstractView) it.next();
			map.put(vw.getId(), vw.getName());
		}
		return map;
	}

	/**
	 * 根据模块主键与应用标识查询,返回表单集合
	 * 
	 * @param moduleid
	 *            模块主键
	 * @param application
	 * 应用标识
	 * @return 表单集合
	 * @throws Exception
	 */
	public Map<String, String> getFormByModule(String moduleid,
			String application) throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		if (moduleid.equals("")) {
			return map;
		}
		FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
		Collection<Form> col = fp.getFormsByModule(moduleid, application);

		Iterator<Form> it = col.iterator();
		while (it.hasNext()) {
			Form fm = (Form) it.next();
			map.put(fm.getId(), fm.getName());
		}
		return map;
	}

	/**
	 * 根据模块主键与应用标识查询,返回普通、映射表单集合
	 * 
	 * @param moduleid
	 *            模块主键
	 * @return 普通、映射表单集合
	 * @throws Exception
	 */
	public Map<String, String> getNormalAndMappingFormByModule(String moduleid,
			String application) throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		if (moduleid.equals("")) {
			return map;
		}
		FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
		Collection<Form> col = fp.getFormsByModule(moduleid, application);

		Iterator<Form> it = col.iterator();
		while (it.hasNext()) {
			Form fm = (Form) it.next();
			if (fm.getType() == Form.FORM_TYPE_NORMAL
					|| fm.getType() == Form.FORM_TYPE_NORMAL_MAPPING) {
				map.put(fm.getId(), fm.getName());
			}
		}
		return map;
	}
	
	
	/**
	 * 根据模块主键获取模板表单
	 * 
	 * @param moduleid
	 *            模块主键
	 * @return 普通、映射表单集合
	 * @throws Exception
	 */
	public Map<String, String> getTemplateFormByModule(String moduleid,
			String application) throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		if (moduleid.equals("")) {
			return map;
		}
		
		FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
		Collection<Form> col = fp.getTemplateFormsByModule(moduleid, application);

		Iterator<Form> it = col.iterator();
		while (it.hasNext()) {
			Form fm = (Form) it.next();
			if(fm.getType() == Form.FORM_TYPE_TEMPLATEFORM){
				map.put(fm.getId(), fm.getName());
			}
		}
		return map;
	}
	
	/**
	 * 根据模块主键查询,返回流程集合
	 * 
	 * @param moduleid
	 *            模块主键
	 * 
	 * @return 流程集合
	 * @throws Exception
	 */
	public Map<String, String> getFlowByModule(String moduleid)
			throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		if (moduleid.equals("")) {
			return map;
		}

		BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
		Collection<BillDefiVO> col = bp.getBillDefiByModule(moduleid);

		Iterator<BillDefiVO> it = col.iterator();
		while (it.hasNext()) {
			BillDefiVO bv = (BillDefiVO) it.next();
			map.put(bv.getId(), bv.getSubject());
		}
		return map;
	}

	/**
	 * 获取视图所适用的按钮
	 * 
	 * @param selectFieldName
	 *            下拉框名称
	 * @param def
	 *            默认值
	 * @return 添加选项的JS脚本
	 */
	public String createViewType(String selectFieldName, String def) {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("0", "{*[Select]*}");
		map.putAll(ActivityType.getViewActTypeMapWithMulti());

		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/**
	 * 获取表单所适用的按钮
	 * 
	 * @param selectFieldName
	 *            下拉框名称
	 * @param def
	 *            默认值
	 * @return 添加选项的JS脚本
	 */
	public String createFormType(String selectFieldName, String def) {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("0", "{*[Select]*}");
		map.putAll(ActivityType.getFormActTypeMapWithMulti());

		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/**
	 * 获取表单所适用的按钮除了跳转按钮和跳转页面按钮之外
	 * 
	 * @param selectFieldName
	 * @param def
	 * @return
	 */
	public String createFormTypeExceptJUMPAndDispatcher(String selectFieldName, String def) {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("0", "{*[Select]*}");
		// 遍历每个元素，并加上多语言标签
		map.putAll(ActivityType.getFormActTypeMapWithMulti());
		//跳转按钮
		map.remove(String.valueOf(ActivityType.JUMP));
		//跳转页面按钮
		//map.remove(String.valueOf(ActivityType.DISPATCHER));不过滤since 2013-1-30

		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/**
	 * 返回字符串为重定义后的javascript,创建按钮类型列表框.
	 * 
	 * @param selectFieldName
	 *            按钮描述名
	 * @param def
	 *            按钮值
	 * @return
	 */
	public String createType(String selectFieldName, String def) {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("0", "{*[Select]*}");
		map.putAll(ActivityType.getFormActTypeMapWithMulti());

		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/**
	 * 返回字符串为重定义后的javascript.实现下拉联动的动态加载的活动视图列表框.
	 * <p>
	 * 此重定义后的javascript是根据Activity类型值为ACTIVITY_TYPE_DOCUMENT_QUERY(
	 * Activity的类型为查询Document)的常量值,
	 * 以及所属模块获取的View集合,创建一个下拉联动的活动View(OnActionView)列表框.
	 * 
	 * @see cn.myapps.common.model.activity.Activity
	 * @param selectFieldName
	 *            选择字段名
	 * @param type
	 *            按钮类型(acvitity)
	 * @param moduleid
	 *            所属模块
	 * @param def
	 *            选择字段名值
	 * @param application
	 *            应用标识
	 * @return 字符串为重定义后的javascript.
	 * @throws Exception
	 */
	public String createOnActionView(String selectFieldName, String type,
			String moduleid, String def, String application) throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		if (!StringUtil.isBlank(type)
				&& Integer.parseInt(type) == ActivityType.DOCUMENT_QUERY) {
			map = getViewByModule(moduleid, application);
		}
		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/**
	 * 返回字符串为重定义后的javascript,实现下拉联动的动态加载的活动表单列表框.
	 * <p>
	 * 此重定义后的javascript是根据Activity类型值为ACTIVITY_TYPE_DOCUMENT_CREATE(
	 * Activity的类型为创建Document
	 * )的常量值或ACTIVITY_TYPE_DOCUMENT_UPDATE(Activity的类型为更新Document)的常量值,
	 * 以及所属模块获取的Form集合,创建一个下拉联动的活动Form(OnActionForm)列表框.
	 * 
	 * @see cn.myapps.common.model.activity.Activity#ACTIVITY_TYPE_DOCUMENT_CREATE
	 * @see cn.myapps.common.model.activity.Activity#ACTIVITY_TYPE_DOCUMENT_UPDATE
	 * @param selectFieldName
	 *            选择字段名
	 * @param type
	 *            按钮类型(acvitity)
	 * @param moduleid
	 *            所属模块
	 * @param def
	 *            选择字段名值
	 * @param application
	 *            应用标识
	 * @return 字符串为重定义后的javascript.
	 * @throws Exception
	 */
	public String createOnActionForm(String selectFieldName, String type,
			String moduleid, String def, String application) throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		int typeCode = 0;
		try {
			typeCode = Integer.parseInt(type);
		} catch (NumberFormatException e) {
		}

		if (typeCode == ActivityType.DOCUMENT_CREATE
				|| typeCode == ActivityType.DOCUMENT_UPDATE
				|| typeCode == ActivityType.CLEAR_ALL) {
			map = getNormalAndMappingFormByModule(moduleid, application);
		}
		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/**
	 * 返回字符串为重定义后的javascript,实现下拉联动的动态加载的活动流程列表框.
	 * <p>
	 * 此重定义后的javascript是根据Activity类型值为ACTIVITY_TYPE_WORKFLOW_PROCESS(
	 * Activity的类型为处理流程)的常量值, 以及所属模块获取的Flow集合,创建一个下拉联动的活动Flow(OnActionFlow)列表框.
	 * 
	 * @see cn.myapps.common.model.activity.Activity
	 * 
	 * 
	 * @param selectFieldName
	 *            选择字段名
	 * @param type
	 *            按钮类型(acvitity)
	 * @param moduleid
	 *            所属模块
	 * @param def
	 *            选择字段名值
	 * @return 字符串为重定义后的javascript,实现下拉联动的动态加载活动流程列表框.
	 * @throws Exception
	 */
	public String crateOnActionFlow(String selectFieldName, String type,
			String moduleid, String def) throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		if (!StringUtil.isBlank(type)){
			if(Integer.parseInt(type) == ActivityType.WORKFLOW_PROCESS){
				map = getFlowByModule(moduleid);
			}
		}
		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}
	/**
	 * 
	 * @param selectFieldName
	 * @param type
	 * @param moduleid
	 * @param def
	 * @return
	 * @throws Exception
	 */
	public String createOnActionRelatedForm(String selectFieldName, String type,
			String moduleid, String def, String application) throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		int typeCode = 0;
		try {
			typeCode = Integer.parseInt(type);
		} catch (NumberFormatException e) {
		}

		if (typeCode == ActivityType.NOTHING) {
			map = getTemplateFormByModule(moduleid, application);
		}
		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	/*
	 * 根据模块id来查回流程 @param moduleid 模块id @return map @throws Exception
	 */
	public Map<String, String> getFlowsByModuleid(String moduleid)
			throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		if (moduleid != null && !StringUtil.isBlank(moduleid)) {
			map = getFlowByModule(moduleid);
		}
		return map;
	}

	public String createOnActionPrint(String selectFieldName, String type,
			String moduleid, String def) throws Exception {
		Map<String, String> map = new LinkedHashMap<String, String>();
		if (!StringUtil.isBlank(type)
				&& (Integer.parseInt(type) == ActivityType.FLEX_PRINT || Integer
						.parseInt(type) == ActivityType.FLEX_PRINT_WITHFLOWHIS)) {
			map = getPrintByModule(moduleid);
		}
		return DWRHtmlUtils.createOptions(map, selectFieldName, def);
	}

	public Map<String, String> getPrintByModule(String moduleid)
			throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		if (moduleid.equals("")) {
			return map;
		}

		ReportDesignTimeService pp = DesignTimeServiceManager.reportDesignTimeService();
		Collection<Report> col = pp.getPrinterByModule(moduleid);

		Iterator<Report> it = col.iterator();
		while (it.hasNext()) {
			Report printer = (Report) it.next();
			if(printer.getIsPrint() == 1){
				map.put(printer.getId(), printer.getName());
			}
		}
		return map;
	}

	public List<?> parseXML(String activityXML) {
		return (List<?>) XmlUtil.toOjbect(activityXML);
	}

	public String parseObject(List<Activity> activitySet) {
		return XmlUtil.toXml(activitySet);
	}
	
	public Activity save(Activity activity) throws Exception{
		try {
			List<Activity> activities = new ArrayList<>();
			//获取按钮的父表单id
			String formId = activity.getParentForm();
			if(!StringUtil.isBlank(formId)) {
				FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
				Form form = formService.findById(formId);
				//获取该表单下的按钮
				if(!StringUtil.isBlank(form.getActivityXML())){
					activities = (List<Activity>)parseXML(form.getActivityXML());
				}
			}
			//获取按钮的父视图id
			String viewId = activity.getParentView();
			if(!StringUtil.isBlank(viewId)) {
				ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
				AbstractView view = viewService.findById(viewId);
				//获取该视图下的按钮
				if(!StringUtil.isBlank(view.getActivityXML())){
					activities = (List<Activity>)parseXML(view.getActivityXML());
				}
			}
			//校验名称是否已存在
			for(Activity act: activities) {
				if(act != null &&  (StringUtil.isBlank(activity.getId()) || !act.getId().equals(activity.getId()))  && activity.getName().equals(act.getName())) {
					throw new Exception("该按钮名称已存在");
				}
			}

			ActivityDesignTimeService service = DesignTimeServiceManager.activityDesignTimeService();
			if(!StringUtil.isBlank(activity.getParentForm())){
				activity.setParentId(activity.getParentForm());
			}else{
				activity.setParentId(activity.getParentView());
			}
			service.saveOrUpdate(activity);
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
		return activity;
	}
	
	public int remove(String id) {
		try {
			ActivityDesignTimeService service = DesignTimeServiceManager.activityDesignTimeService();
			service.delete(id);
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
		return 1;
	}
	
	public int swap(String id,String nId){
		try {
			ActivityDesignTimeService service = DesignTimeServiceManager.activityDesignTimeService();
			Activity o = service.findById(id);
			Activity n = service.findById(nId);
			int tempOrder = o.getOrderno();
			o.setOrderno(n.getOrderno());
			n.setOrderno(tempOrder);
			service.update(o);
			service.update(n);
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
		return 1;
	}
	
	public String toListHtml(List<Activity> activitySet,
			HttpServletRequest request) {
		StringBuffer htmlBuilder = new StringBuffer();

		Map<String, String> map = ActivityType.getViewActTypeMapWithMulti();
		Map<String, String> formactMap = ActivityType
				.getFormActTypeMapWithMulti();
		int index = 0;
		htmlBuilder.append("<div id='contentTable' class='obpm-list-table'><table class='table_noborder tableTOver'>");
		htmlBuilder
				.append("<tr style='height:44px;' class='obpm-table-title'><td class='obpm-checkbox-col obpm-checkbox-section'><input id='table-content-title-act' type='checkbox' onclick='selectAllAct(this.checked)'><label class='obpm-checkbox' for='table-content-title-act'></label></td><td>{*[Activity]*}{*[Name]*}</td><td>{*[Activity]*}{*[Type]*}</td><td>{*[Move_Up]*}</td><td>{*[Move_Down]*}</td></tr>");
		String contextPath = request.getContextPath();

		for (Iterator<Activity> iterator = activitySet.iterator(); iterator
				.hasNext(); index++) {

			Activity activity = (Activity) iterator.next();
			if (index % 2 == 0) {
				htmlBuilder.append("<tr class='obpm-activity-table'>");
			} else {
				htmlBuilder.append("<tr class='obpm-activity-table'>");
			}
			htmlBuilder.append("<td class='obpm-checkbox-col obpm-checkbox-section'>");
			htmlBuilder
					.append("<input id='act_selects"+index+"' type=\"checkbox\" name=\"activitySelects\" value="
							+ index + ">");
			htmlBuilder.append("<label class='obpm-checkbox' for='act_selects"+index+"'></td>");

			htmlBuilder.append("<td>");
			htmlBuilder.append("<a href=\"javascript:actProcess.doEdit("
					+ index + ")\" style=\"cursor:hand\">" + activity.getName()
					+ "</a>");
			htmlBuilder.append("</td>");

			htmlBuilder.append("<td>");
			String actType = (String) formactMap.get(activity.getType() + "");
			if (actType == null) {
				actType = (String) map.get(activity.getType() + "");
			}
			htmlBuilder.append("<a style=\"cursor:hand\">" + actType + "</a>");
			htmlBuilder.append("</td>");

			htmlBuilder.append("<td>");
			htmlBuilder.append("<a href=\"javascript:actProcess.doOrderChange("
					+ index + ", 'p')\"><img border=0 SRC=\"" + contextPath
					+ "/resource/image/leftStep.GIF\"></a>");
			htmlBuilder.append("</td>");

			htmlBuilder.append("<td>");
			htmlBuilder.append("<a href=\"javascript:actProcess.doOrderChange("
					+ index + ", 'n')\"><img border=0 SRC=\"" + contextPath
					+ "/resource/image/rightStep.GIF\"></a>");
			htmlBuilder.append("</td>");
			htmlBuilder.append("</tr>");

		}
		htmlBuilder.append("</table></div>");

		return htmlBuilder.toString();

	}
	
	public String getPrinterName(String printerId) throws Exception {
		ReportDesignTimeService pp = DesignTimeServiceManager.reportDesignTimeService();
		if(!StringUtil.isBlank(printerId)){
			Report printer = (Report) pp.doView(printerId);
			if(printer != null){
				return printer.getName();
			}
		}
		return "";
	}
	
	
}
