package cn.myapps.designtime.activity.controller;

import static com.jayway.jsonpath.JsonPath.parse;

import java.util.List;

import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@Api(tags = "操作设计模块")
@Component
@RequestMapping(path = "/api/designtime/applications", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ActivityController extends AbstractDesignTimeController {

    private ActivityDesignTimeService activityService;

    public ActivityController() throws Exception {
        activityService = DesignTimeServiceManager.activityDesignTimeService();
    }

    /**
     * 获取操作详情
     *
     * @param activityId 操作id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/activitys/{activityId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取操作详情", notes = "获取操作详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "操作id", required = true, paramType = "path", dataType = "string")
    })
    public Resource doGetActivityDetail(@PathVariable String activityId) throws Exception {
        try {
            Activity activity = activityService.findById(activityId);
            return success("ok", activity);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 新建操作
     *
     * @param applicationId 软件id
     * @param parentId 操作对应id（表单或者视图）
     * @param content  请求包体
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/{applicationId}/modules/activitys")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "新建操作", notes = "新建操作")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "parentId", value = "操作对应id（表单或者视图）", required = true, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doCreateActivity(@PathVariable String applicationId, @RequestParam String parentId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject(content);
            Activity activity = (Activity)json2obj(json,Activity.class);

            String activityId = Sequence.getDesignTimeSequence();
            activity.setId(activityId);
            activity.setParentId(parentId);
            activity.setApplicationid(applicationId);

            activityService.save(activity);

            JSONObject activityJson = new JSONObject();
            activityJson.put("id", activityId);

            return success("ok", activityJson);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新操作
     *
     * @param applicationId 软件id
     * @param activityId 操作id
     * @param parentId 操作对应id（表单或者视图）
     * @param content  请求包体
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/{applicationId}/modules/activitys/{activityId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新操作", notes = "更新操作")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "activityId", value = "操作id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "parentId", value = "操作对应id（表单或者视图）", required = true, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdateActivity(@PathVariable String applicationId, @PathVariable String activityId, @RequestParam String parentId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject(content);
            Activity activity = (Activity)json2obj(json,Activity.class);

            activity.setId(activityId);
            activity.setParentId(parentId);
            activity.setApplicationid(applicationId);

            activityService.update(activity);

            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除操作（可批量）
     *
     * @param content 请求包体
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/modules/activitys")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除操作", notes = "删除操作（可批量）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doDeleteForm(@RequestBody String content) throws Exception {
        try {
            List<String> ids = parse(content).json();
            String[] idArray = {};
            idArray = ids.toArray(idArray);

            activityService.delete(idArray);

            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
}
