package cn.myapps.conf;

import cn.myapps.common.util.DbUtil;
import cn.myapps.components.MessageProvider;
import cn.myapps.components.SettingProvider;
import cn.myapps.components.requests.CreateMessageRequest;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import javax.sql.DataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by arnold.zhu on 6/13/2017.
 */
@ConditionalOnProperty("${spring.datasource}")
@Configuration
public class DataSourceConfig implements TransactionManagementConfigurer {

    private Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);

    @Value("${spring.datasource.url}")
    private String dbUrl;

    @Value("${spring.datasource.username}")
    private String username;

    @Value("${spring.datasource.password}")
    private String password;

    @Value("${spring.datasource.driver-class-name}")
    private String driverClassName;

    @Value("${spring.datasource.initialSize}")
    private int initialSize;

    @Value("${spring.datasource.minIdle}")
    private int minIdle;

    @Value("${spring.datasource.maxActive}")
    private int maxActive;

    @Value("${spring.datasource.maxWait}")
    private int maxWait;

    @Value("${spring.datasource.timeBetweenEvictionRunsMillis}")
    private int timeBetweenEvictionRunsMillis;

    @Value("${spring.datasource.minEvictableIdleTimeMillis}")
    private int minEvictableIdleTimeMillis;

    @Value("${spring.datasource.validationQuery}")
    private String validationQuery;

    @Value("${spring.datasource.testWhileIdle}")
    private boolean testWhileIdle;

    @Value("${spring.datasource.testOnBorrow}")
    private boolean testOnBorrow;

    @Value("${spring.datasource.testOnReturn}")
    private boolean testOnReturn;

    @Value("${spring.datasource.filters}")
    private String filters;

    @Value("${spring.datasource.logSlowSql}")
    private String logSlowSql;

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.setServlet(new StatViewServlet());
        reg.addUrlMappings("/core/monitor/druid/*");
//        reg.addInitParameter("loginUsername", username);
//        reg.addInitParameter("loginPassword", password);
        reg.addInitParameter("logSlowSql", logSlowSql);
        return reg;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(new WebStatFilter());
        filterRegistrationBean.addUrlPatterns("/druid/*");
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        filterRegistrationBean.addInitParameter("profileEnable", "true");
        return filterRegistrationBean;
    }

    @Bean
    public DataSource druidDataSource() {
        DataSource ds = null;
        int intMaxActive = maxActive;
        if(intMaxActive<10000) {
            intMaxActive = 10000;
        }

        if (maxWait < 100) {
            maxWait = 3600;
        }

        Map<String, String> properties = new HashMap<String, String>();
        if (driverClassName.contains("com.mysql.jdbc.Driver")) {
            driverClassName = "com.mysql.cj.jdbc.Driver";
        }
        if (driverClassName.contains("mysql")) {
            dbUrl = dbUrl.replace("&serverTimezone=GMT%2B8", "");
            dbUrl = dbUrl.replace("&serverTimezone=GMT", "");

            dbUrl += "&serverTimezone=GMT%2B8";
        }
        properties.put("driverClassName", driverClassName);
        properties.put("url", dbUrl);
        properties.put("username", username);
        properties.put("password", password);
        properties.put("maxActive", String.valueOf(intMaxActive));
        properties.put("maxWait", String.valueOf(maxWait));
        properties.put("timeBetweenEvictionRunsMillis", "60000");
        properties.put("minEvictableIdleTimeMillis", "300000");
        properties.put("testWhileIdle", String.valueOf(testWhileIdle));
        properties.put("testOnBorrow", String.valueOf(testOnBorrow));
        properties.put("testOnReturn", String.valueOf(testOnReturn));
        validationQuery = DbUtil.getValidationQuery(driverClassName);
        properties.put("validationQuery", validationQuery);
        properties.put("maxPoolPreparedStatementPerConnectionSize", "200");
        properties.put("removeAbandoned", "true");
        properties.put("removeAbandonedTimeout", "120");
        try {
            ds = DruidDataSourceFactory.createDataSource(properties);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }


    @Bean
    public JdbcTemplate jdbcTemplate(DataSource kmDataSource) {
        return new JdbcTemplate(kmDataSource);

    }

    @Override
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(druidDataSource());
    }


    @Bean
    public MessageProvider messageProvider() {
        return new MessageProvider() {
            @Override
            public void dispatch(String senderId, MessageType messageType, String title, String content, ReceiverType receiverType, String receiver, String businessNumber, String uniqueId) {

            }

            @Override
            public void dispatch(CreateMessageRequest request) {

            }

            @Override
            public void dispatch(Collection<CreateMessageRequest> requests) {

            }
        };
    }

    @Bean
    public SettingProvider settingProvider() {
        return new SettingProvider() {
            @Override
            public String getSettingWithCache(String category, String key, int seconds) {
                return null;
            }

            @Override
            public String getSetting(String category, String key) {
                return null;
            }
        };
    }
}