const path = require("path");
const HtmlwebpackPlugin = require("html-webpack-plugin");
const CopyWebpackPlugin = require("copy-webpack-plugin");

module.exports = {
  mode: "development",
  entry: {
    camelDesign: "./src/index.js",
  },
  devtool: "inline-source-map",
  devServer: {
    contentBase: "./dist",
    compress: true,
    hot: true,
    open: "Google Chrome",
    port: 5656,
    proxy: {
      "/designer": "http://localhost:8081/",
    },
  },

  plugins: [
    new HtmlwebpackPlugin({
      title: "Webpack-demos",
      filename: "index.html",
      template: "index.html",
    }),
    new CopyWebpackPlugin([{ from: "./json/config.json", to: "./json/config.json" }], { ignore: [], copyUnmodified: true }),
    new CopyWebpackPlugin([{ from: "./tpl/*.html", to: "./tpl/[name].html" }], { ignore: [], copyUnmodified: true }),
    new CopyWebpackPlugin([{ from: "./css/*.css", to: "./css/[name].css" }], { ignore: [], copyUnmodified: true }),
    new CopyWebpackPlugin([{ from: "./images/*.*", to: "./images/[name].[ext]" }], { ignore: [], copyUnmodified: true }),
    // 兼容js文件夹下的第一层js文件
    new CopyWebpackPlugin([{ from: "./script/*.js", to: "./script/[name].js" }], { ignore: [], copyUnmodified: true }),
    new CopyWebpackPlugin([{ from: "./fonts/*.*", to: "./fonts/[name].[ext]" }], { ignore: [], copyUnmodified: true }),
  ],
  module: {
    rules: [
      {
        test: /\.scss$/,
        use: ["style-loader", "css-loader", "sass-loader"],
      },

      {
        test: /\.woff2?/,
        loader: "url-loader",
        options: {
          name: "[path][name].[ext]?[hash]",
          mimetype: "application/font-woff",
        },
      },
      {
        test: /\.(jpe?g|gif|svg|ico|ttf|otf|eot|woff|woff2)(\?[a-z0-9=&.]+)?$/i,
        loader: "file-loader",
        options: {
          name: "[path][name].[ext]?[hash]",
        },
      },

      {
        test: /\.png$/,
        loader: "file-loader",
        options: {
          name: "[path]/[name].[ext]?[hash]",
        },
      },
      {
        test: /\.(js?|jsx?|es6)$/,
        exclude: /node_modules/,
        loader: "babel-loader",
        query: {
          presets: [
            "env",
            "es2015",
            "stage-3",
            [
              "babel-preset-env",
              {
                useBuiltIns: "usage",
              },
            ],
          ],
        },
      },
    ],
  },
  output: {
    publicPath: "",
    filename: "./[name].js",
    path: path.resolve(__dirname, "./dist"),
  },
};
